package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepRequiredCapabilities(
    attributes: Iterable[zio.aws.deadline.model.StepAttributeCapability],
    amounts: Iterable[zio.aws.deadline.model.StepAmountCapability]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepRequiredCapabilities = {
    import StepRequiredCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepRequiredCapabilities
      .builder()
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .amounts(amounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepRequiredCapabilities.ReadOnly =
    zio.aws.deadline.model.StepRequiredCapabilities.wrap(buildAwsValue())
}
object StepRequiredCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepRequiredCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepRequiredCapabilities =
      zio.aws.deadline.model.StepRequiredCapabilities(
        attributes.map { item =>
          item.asEditable
        },
        amounts.map { item =>
          item.asEditable
        }
      )
    def attributes
        : List[zio.aws.deadline.model.StepAttributeCapability.ReadOnly]
    def amounts: List[zio.aws.deadline.model.StepAmountCapability.ReadOnly]
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepAttributeCapability.ReadOnly
    ]] = ZIO.succeed(attributes)
    def getAmounts: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepAmountCapability.ReadOnly
    ]] = ZIO.succeed(amounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepRequiredCapabilities
  ) extends zio.aws.deadline.model.StepRequiredCapabilities.ReadOnly {
    override val attributes
        : List[zio.aws.deadline.model.StepAttributeCapability.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepAttributeCapability.wrap(item)
      }
      .toList
    override val amounts
        : List[zio.aws.deadline.model.StepAmountCapability.ReadOnly] = impl
      .amounts()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepAmountCapability.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepRequiredCapabilities
  ): zio.aws.deadline.model.StepRequiredCapabilities.ReadOnly = new Wrapper(
    impl
  )
}
