package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  CreatedAt,
  StepId,
  StepName,
  EndedAt,
  JobId,
  StartedAt
}
import scala.jdk.CollectionConverters._
final case class StepSearchSummary(
    stepId: Optional[StepId] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    queueId: Optional[QueueId] = Optional.Absent,
    name: Optional[StepName] = Optional.Absent,
    lifecycleStatus: Optional[zio.aws.deadline.model.StepLifecycleStatus] =
      Optional.Absent,
    lifecycleStatusMessage: Optional[String] = Optional.Absent,
    taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      Optional.Absent,
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.StepTargetTaskRunStatus
    ] = Optional.Absent,
    taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    parameterSpace: Optional[zio.aws.deadline.model.ParameterSpace] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepSearchSummary = {
    import StepSearchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepSearchSummary
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        name.map(value => StepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(lifecycleStatus.map(value => value.unwrap))(
        _.lifecycleStatus
      )
      .optionallyWith(
        lifecycleStatusMessage.map(value => value: java.lang.String)
      )(_.lifecycleStatusMessage)
      .optionallyWith(taskRunStatus.map(value => value.unwrap))(_.taskRunStatus)
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .optionallyWith(
        taskRunStatusCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: Integer)
            })
            .asJava
        )
      )(_.taskRunStatusCountsWithStrings)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(parameterSpace.map(value => value.buildAwsValue()))(
        _.parameterSpace
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepSearchSummary.ReadOnly =
    zio.aws.deadline.model.StepSearchSummary.wrap(buildAwsValue())
}
object StepSearchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepSearchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepSearchSummary =
      zio.aws.deadline.model.StepSearchSummary(
        stepId.map(value => value),
        jobId.map(value => value),
        queueId.map(value => value),
        name.map(value => value),
        lifecycleStatus.map(value => value),
        lifecycleStatusMessage.map(value => value),
        taskRunStatus.map(value => value),
        targetTaskRunStatus.map(value => value),
        taskRunStatusCounts.map(value => value),
        createdAt.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value),
        parameterSpace.map(value => value.asEditable)
      )
    def stepId: Optional[StepId]
    def jobId: Optional[JobId]
    def queueId: Optional[QueueId]
    def name: Optional[StepName]
    def lifecycleStatus: Optional[zio.aws.deadline.model.StepLifecycleStatus]
    def lifecycleStatusMessage: Optional[String]
    def taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus]
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.StepTargetTaskRunStatus]
    def taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]]
    def createdAt: Optional[CreatedAt]
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def parameterSpace: Optional[zio.aws.deadline.model.ParameterSpace.ReadOnly]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getName: ZIO[Any, AwsError, StepName] =
      AwsError.unwrapOptionField("name", name)
    def getLifecycleStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.StepLifecycleStatus] =
      AwsError.unwrapOptionField("lifecycleStatus", lifecycleStatus)
    def getLifecycleStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lifecycleStatusMessage", lifecycleStatusMessage)
    def getTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.TaskRunStatus] =
      AwsError.unwrapOptionField("taskRunStatus", taskRunStatus)
    def getTargetTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.StepTargetTaskRunStatus] =
      AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getTaskRunStatusCounts: ZIO[Any, AwsError, Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = AwsError.unwrapOptionField("taskRunStatusCounts", taskRunStatusCounts)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getParameterSpace
        : ZIO[Any, AwsError, zio.aws.deadline.model.ParameterSpace.ReadOnly] =
      AwsError.unwrapOptionField("parameterSpace", parameterSpace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepSearchSummary
  ) extends zio.aws.deadline.model.StepSearchSummary.ReadOnly {
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.deadline.model.primitives.StepId(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
    override val name: Optional[StepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.deadline.model.primitives.StepName(value))
    override val lifecycleStatus
        : Optional[zio.aws.deadline.model.StepLifecycleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatus())
        .map(value => zio.aws.deadline.model.StepLifecycleStatus.wrap(value))
    override val lifecycleStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatusMessage())
        .map(value => value: String)
    override val taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskRunStatus())
        .map(value => zio.aws.deadline.model.TaskRunStatus.wrap(value))
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.StepTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value =>
          zio.aws.deadline.model.StepTargetTaskRunStatus.wrap(value)
        )
    override val taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRunStatusCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.deadline.model.TaskRunStatus
              .wrap(key) -> (value: zio.aws.deadline.model.primitives.Integer)
          })
          .toMap
      )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.deadline.model.primitives.CreatedAt(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val parameterSpace
        : Optional[zio.aws.deadline.model.ParameterSpace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterSpace())
        .map(value => zio.aws.deadline.model.ParameterSpace.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepSearchSummary
  ): zio.aws.deadline.model.StepSearchSummary.ReadOnly = new Wrapper(impl)
}
