package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  UpdatedBy,
  CreatedAt,
  StepId,
  StepName,
  EndedAt,
  CreatedBy,
  StartedAt,
  UpdatedAt
}
import scala.jdk.CollectionConverters._
final case class StepSummary(
    stepId: StepId,
    name: StepName,
    lifecycleStatus: zio.aws.deadline.model.StepLifecycleStatus,
    lifecycleStatusMessage: Optional[String] = Optional.Absent,
    taskRunStatus: zio.aws.deadline.model.TaskRunStatus,
    taskRunStatusCounts: Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ],
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.StepTargetTaskRunStatus
    ] = Optional.Absent,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    dependencyCounts: Optional[zio.aws.deadline.model.DependencyCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StepSummary = {
    import StepSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StepSummary
      .builder()
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .name(StepName.unwrap(name): java.lang.String)
      .lifecycleStatus(lifecycleStatus.unwrap)
      .optionallyWith(
        lifecycleStatusMessage.map(value => value: java.lang.String)
      )(_.lifecycleStatusMessage)
      .taskRunStatus(taskRunStatus.unwrap)
      .taskRunStatusCountsWithStrings(
        taskRunStatusCounts
          .map({ case (key, value) =>
            key.unwrap.toString -> (value: Integer)
          })
          .asJava
      )
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(dependencyCounts.map(value => value.buildAwsValue()))(
        _.dependencyCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StepSummary.ReadOnly =
    zio.aws.deadline.model.StepSummary.wrap(buildAwsValue())
}
object StepSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StepSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StepSummary =
      zio.aws.deadline.model.StepSummary(
        stepId,
        name,
        lifecycleStatus,
        lifecycleStatusMessage.map(value => value),
        taskRunStatus,
        taskRunStatusCounts,
        targetTaskRunStatus.map(value => value),
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value),
        dependencyCounts.map(value => value.asEditable)
      )
    def stepId: StepId
    def name: StepName
    def lifecycleStatus: zio.aws.deadline.model.StepLifecycleStatus
    def lifecycleStatusMessage: Optional[String]
    def taskRunStatus: zio.aws.deadline.model.TaskRunStatus
    def taskRunStatusCounts: Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.StepTargetTaskRunStatus]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def dependencyCounts
        : Optional[zio.aws.deadline.model.DependencyCounts.ReadOnly]
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getName: ZIO[Any, Nothing, StepName] = ZIO.succeed(name)
    def getLifecycleStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.StepLifecycleStatus] =
      ZIO.succeed(lifecycleStatus)
    def getLifecycleStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lifecycleStatusMessage", lifecycleStatusMessage)
    def getTaskRunStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.TaskRunStatus] =
      ZIO.succeed(taskRunStatus)
    def getTaskRunStatusCounts: ZIO[Any, Nothing, Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = ZIO.succeed(taskRunStatusCounts)
    def getTargetTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.StepTargetTaskRunStatus] =
      AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getDependencyCounts
        : ZIO[Any, AwsError, zio.aws.deadline.model.DependencyCounts.ReadOnly] =
      AwsError.unwrapOptionField("dependencyCounts", dependencyCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StepSummary
  ) extends zio.aws.deadline.model.StepSummary.ReadOnly {
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val name: StepName =
      zio.aws.deadline.model.primitives.StepName(impl.name())
    override val lifecycleStatus: zio.aws.deadline.model.StepLifecycleStatus =
      zio.aws.deadline.model.StepLifecycleStatus.wrap(impl.lifecycleStatus())
    override val lifecycleStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatusMessage())
        .map(value => value: String)
    override val taskRunStatus: zio.aws.deadline.model.TaskRunStatus =
      zio.aws.deadline.model.TaskRunStatus.wrap(impl.taskRunStatus())
    override val taskRunStatusCounts: Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ] = impl
      .taskRunStatusCounts()
      .asScala
      .map({ case (key, value) =>
        zio.aws.deadline.model.TaskRunStatus
          .wrap(key) -> (value: zio.aws.deadline.model.primitives.Integer)
      })
      .toMap
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.StepTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value =>
          zio.aws.deadline.model.StepTargetTaskRunStatus.wrap(value)
        )
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val dependencyCounts
        : Optional[zio.aws.deadline.model.DependencyCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dependencyCounts())
        .map(value => zio.aws.deadline.model.DependencyCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StepSummary
  ): zio.aws.deadline.model.StepSummary.ReadOnly = new Wrapper(impl)
}
