package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait StepTargetTaskRunStatus {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus
}
object StepTargetTaskRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus
  ): zio.aws.deadline.model.StepTargetTaskRunStatus = value match {
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.READY
  }
  case object FAILED extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.SUCCEEDED
  }
  case object CANCELED extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.CANCELED
  }
  case object SUSPENDED extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.SUSPENDED
  }
  case object PENDING extends zio.aws.deadline.model.StepTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus.PENDING
  }
}
