package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{ResourceName, StorageProfileId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StorageProfileSummary(
    storageProfileId: StorageProfileId,
    displayName: ResourceName,
    osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StorageProfileSummary = {
    import StorageProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StorageProfileSummary
      .builder()
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .displayName(ResourceName.unwrap(displayName): java.lang.String)
      .osFamily(osFamily.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StorageProfileSummary.ReadOnly =
    zio.aws.deadline.model.StorageProfileSummary.wrap(buildAwsValue())
}
object StorageProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StorageProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StorageProfileSummary =
      zio.aws.deadline.model
        .StorageProfileSummary(storageProfileId, displayName, osFamily)
    def storageProfileId: StorageProfileId
    def displayName: ResourceName
    def osFamily: zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
    def getDisplayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(displayName)
    def getOsFamily: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = ZIO.succeed(osFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StorageProfileSummary
  ) extends zio.aws.deadline.model.StorageProfileSummary.ReadOnly {
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
    override val displayName: ResourceName =
      zio.aws.deadline.model.primitives.ResourceName(impl.displayName())
    override val osFamily
        : zio.aws.deadline.model.StorageProfileOperatingSystemFamily =
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
        .wrap(impl.osFamily())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StorageProfileSummary
  ): zio.aws.deadline.model.StorageProfileSummary.ReadOnly = new Wrapper(impl)
}
