package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StringFilter
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StringFilterExpression(
    name: String,
    operator: zio.aws.deadline.model.ComparisonOperator,
    value: StringFilter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.StringFilterExpression = {
    import StringFilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.StringFilterExpression
      .builder()
      .name(name: java.lang.String)
      .operator(operator.unwrap)
      .value(StringFilter.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.StringFilterExpression.ReadOnly =
    zio.aws.deadline.model.StringFilterExpression.wrap(buildAwsValue())
}
object StringFilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.StringFilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.StringFilterExpression =
      zio.aws.deadline.model.StringFilterExpression(name, operator, value)
    def name: String
    def operator: zio.aws.deadline.model.ComparisonOperator
    def value: StringFilter
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.deadline.model.ComparisonOperator] =
      ZIO.succeed(operator)
    def getValue: ZIO[Any, Nothing, StringFilter] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.StringFilterExpression
  ) extends zio.aws.deadline.model.StringFilterExpression.ReadOnly {
    override val name: String = impl.name(): String
    override val operator: zio.aws.deadline.model.ComparisonOperator =
      zio.aws.deadline.model.ComparisonOperator.wrap(impl.operator())
    override val value: StringFilter =
      zio.aws.deadline.model.primitives.StringFilter(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.StringFilterExpression
  ): zio.aws.deadline.model.StringFilterExpression.ReadOnly = new Wrapper(impl)
}
