package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SyncInputJobAttachmentsSessionActionDefinition(
    stepId: Optional[StepId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition = {
    import SyncInputJobAttachmentsSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
      .wrap(buildAwsValue())
}
object SyncInputJobAttachmentsSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition =
      zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition(
        stepId.map(value => value)
      )
    def stepId: Optional[StepId]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
  ) extends zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly {
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.deadline.model.primitives.StepId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition
  ): zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
