package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SyncInputJobAttachmentsSessionActionDefinitionSummary(
    stepId: Optional[StepId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary = {
    import SyncInputJobAttachmentsSessionActionDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly =
    zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
      .wrap(buildAwsValue())
}
object SyncInputJobAttachmentsSessionActionDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary =
      zio.aws.deadline.model
        .SyncInputJobAttachmentsSessionActionDefinitionSummary(
          stepId.map(value => value)
        )
    def stepId: Optional[StepId]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
  ) extends zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly {
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.deadline.model.primitives.StepId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary
  ): zio.aws.deadline.model.SyncInputJobAttachmentsSessionActionDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
