package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: String,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.TagResourceRequest.ReadOnly =
    zio.aws.deadline.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.TagResourceRequest =
      zio.aws.deadline.model
        .TagResourceRequest(resourceArn, tags.map(value => value))
    def resourceArn: String
    def tags: Optional[Map[String, String]]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.TagResourceRequest
  ) extends zio.aws.deadline.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.TagResourceRequest
  ): zio.aws.deadline.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
