package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, TaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TaskRunSessionActionDefinition(
    taskId: TaskId,
    stepId: StepId,
    parameters: Map[String, zio.aws.deadline.model.TaskParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition = {
    import TaskRunSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .parameters(
        parameters
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.TaskRunSessionActionDefinition.wrap(buildAwsValue())
}
object TaskRunSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.TaskRunSessionActionDefinition =
      zio.aws.deadline.model.TaskRunSessionActionDefinition(
        taskId,
        stepId,
        parameters.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def taskId: TaskId
    def stepId: StepId
    def parameters
        : Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getParameters: ZIO[Any, Nothing, Map[
      String,
      zio.aws.deadline.model.TaskParameterValue.ReadOnly
    ]] = ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition
  ) extends zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly {
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val parameters
        : Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly] = impl
      .parameters()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.deadline.model.TaskParameterValue.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition
  ): zio.aws.deadline.model.TaskRunSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
