package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, TaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TaskRunSessionActionDefinitionSummary(
    taskId: TaskId,
    stepId: StepId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary = {
    import TaskRunSessionActionDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly =
    zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary
      .wrap(buildAwsValue())
}
object TaskRunSessionActionDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary =
      zio.aws.deadline.model
        .TaskRunSessionActionDefinitionSummary(taskId, stepId)
    def taskId: TaskId
    def stepId: StepId
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary
  ) extends zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly {
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinitionSummary
  ): zio.aws.deadline.model.TaskRunSessionActionDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
