package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait TaskRunStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.TaskRunStatus
}
object TaskRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.TaskRunStatus
  ): zio.aws.deadline.model.TaskRunStatus = value match {
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.ASSIGNED =>
      val r = ASSIGNED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.INTERRUPTING =>
      val r = INTERRUPTING
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.TaskRunStatus.NOT_COMPATIBLE =>
      val r = NOT_COMPATIBLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.PENDING
  }
  case object READY extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.READY
  }
  case object ASSIGNED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.ASSIGNED
  }
  case object STARTING extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.STARTING
  }
  case object SCHEDULED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.SCHEDULED
  }
  case object INTERRUPTING extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.INTERRUPTING
  }
  case object RUNNING extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.RUNNING
  }
  case object SUSPENDED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.SUSPENDED
  }
  case object CANCELED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.CANCELED
  }
  case object FAILED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.SUCCEEDED
  }
  case object NOT_COMPATIBLE extends zio.aws.deadline.model.TaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskRunStatus.NOT_COMPATIBLE
  }
}
