package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  StepId,
  EndedAt,
  JobId,
  TaskRetryCount,
  StartedAt,
  TaskId
}
import scala.jdk.CollectionConverters._
final case class TaskSearchSummary(
    taskId: Optional[TaskId] = Optional.Absent,
    stepId: Optional[StepId] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    queueId: Optional[QueueId] = Optional.Absent,
    runStatus: Optional[zio.aws.deadline.model.TaskRunStatus] = Optional.Absent,
    targetRunStatus: Optional[zio.aws.deadline.model.TaskTargetRunStatus] =
      Optional.Absent,
    parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue]
    ] = Optional.Absent,
    failureRetryCount: Optional[TaskRetryCount] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.TaskSearchSummary = {
    import TaskSearchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.TaskSearchSummary
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(runStatus.map(value => value.unwrap))(_.runStatus)
      .optionallyWith(targetRunStatus.map(value => value.unwrap))(
        _.targetRunStatus
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        failureRetryCount.map(value => TaskRetryCount.unwrap(value): Integer)
      )(_.failureRetryCount)
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.TaskSearchSummary.ReadOnly =
    zio.aws.deadline.model.TaskSearchSummary.wrap(buildAwsValue())
}
object TaskSearchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.TaskSearchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.TaskSearchSummary =
      zio.aws.deadline.model.TaskSearchSummary(
        taskId.map(value => value),
        stepId.map(value => value),
        jobId.map(value => value),
        queueId.map(value => value),
        runStatus.map(value => value),
        targetRunStatus.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        failureRetryCount.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value)
      )
    def taskId: Optional[TaskId]
    def stepId: Optional[StepId]
    def jobId: Optional[JobId]
    def queueId: Optional[QueueId]
    def runStatus: Optional[zio.aws.deadline.model.TaskRunStatus]
    def targetRunStatus: Optional[zio.aws.deadline.model.TaskTargetRunStatus]
    def parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    ]
    def failureRetryCount: Optional[TaskRetryCount]
    def startedAt: Optional[StartedAt]
    def endedAt: Optional[EndedAt]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getRunStatus: ZIO[Any, AwsError, zio.aws.deadline.model.TaskRunStatus] =
      AwsError.unwrapOptionField("runStatus", runStatus)
    def getTargetRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.TaskTargetRunStatus] =
      AwsError.unwrapOptionField("targetRunStatus", targetRunStatus)
    def getParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.TaskParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getFailureRetryCount: ZIO[Any, AwsError, TaskRetryCount] =
      AwsError.unwrapOptionField("failureRetryCount", failureRetryCount)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.TaskSearchSummary
  ) extends zio.aws.deadline.model.TaskSearchSummary.ReadOnly {
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.deadline.model.primitives.TaskId(value))
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.deadline.model.primitives.StepId(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
    override val runStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runStatus())
        .map(value => zio.aws.deadline.model.TaskRunStatus.wrap(value))
    override val targetRunStatus
        : Optional[zio.aws.deadline.model.TaskTargetRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetRunStatus())
        .map(value => zio.aws.deadline.model.TaskTargetRunStatus.wrap(value))
    override val parameters: Optional[
      Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.deadline.model.TaskParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val failureRetryCount: Optional[TaskRetryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRetryCount())
        .map(value => zio.aws.deadline.model.primitives.TaskRetryCount(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.TaskSearchSummary
  ): zio.aws.deadline.model.TaskSearchSummary.ReadOnly = new Wrapper(impl)
}
