package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait TaskTargetRunStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus
}
object TaskTargetRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus
  ): zio.aws.deadline.model.TaskTargetRunStatus = value match {
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.READY
  }
  case object FAILED extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.SUCCEEDED
  }
  case object CANCELED extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.CANCELED
  }
  case object SUSPENDED extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.SUSPENDED
  }
  case object PENDING extends zio.aws.deadline.model.TaskTargetRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus =
      software.amazon.awssdk.services.deadline.model.TaskTargetRunStatus.PENDING
  }
}
