package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  BudgetId,
  FarmId,
  Description,
  ClientToken,
  ConsumedUsageLimit,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBudgetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    budgetId: BudgetId,
    displayName: Optional[ResourceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.deadline.model.BudgetStatus] = Optional.Absent,
    approximateDollarLimit: Optional[ConsumedUsageLimit] = Optional.Absent,
    actionsToAdd: Optional[Iterable[zio.aws.deadline.model.BudgetActionToAdd]] =
      Optional.Absent,
    actionsToRemove: Optional[
      Iterable[zio.aws.deadline.model.BudgetActionToRemove]
    ] = Optional.Absent,
    schedule: Optional[zio.aws.deadline.model.BudgetSchedule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest = {
    import UpdateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .budgetId(BudgetId.unwrap(budgetId): java.lang.String)
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        approximateDollarLimit.map(value =>
          ConsumedUsageLimit.unwrap(value): java.lang.Float
        )
      )(_.approximateDollarLimit)
      .optionallyWith(
        actionsToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsToAdd)
      .optionallyWith(
        actionsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsToRemove)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateBudgetRequest.ReadOnly =
    zio.aws.deadline.model.UpdateBudgetRequest.wrap(buildAwsValue())
}
object UpdateBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateBudgetRequest =
      zio.aws.deadline.model.UpdateBudgetRequest(
        clientToken.map(value => value),
        farmId,
        budgetId,
        displayName.map(value => value),
        description.map(value => value),
        status.map(value => value),
        approximateDollarLimit.map(value => value),
        actionsToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actionsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def budgetId: BudgetId
    def displayName: Optional[ResourceName]
    def description: Optional[Description]
    def status: Optional[zio.aws.deadline.model.BudgetStatus]
    def approximateDollarLimit: Optional[ConsumedUsageLimit]
    def actionsToAdd
        : Optional[List[zio.aws.deadline.model.BudgetActionToAdd.ReadOnly]]
    def actionsToRemove
        : Optional[List[zio.aws.deadline.model.BudgetActionToRemove.ReadOnly]]
    def schedule: Optional[zio.aws.deadline.model.BudgetSchedule.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getBudgetId: ZIO[Any, Nothing, BudgetId] = ZIO.succeed(budgetId)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.deadline.model.BudgetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getApproximateDollarLimit: ZIO[Any, AwsError, ConsumedUsageLimit] =
      AwsError.unwrapOptionField(
        "approximateDollarLimit",
        approximateDollarLimit
      )
    def getActionsToAdd: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.BudgetActionToAdd.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsToAdd", actionsToAdd)
    def getActionsToRemove: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.BudgetActionToRemove.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsToRemove", actionsToRemove)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.deadline.model.BudgetSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest
  ) extends zio.aws.deadline.model.UpdateBudgetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val budgetId: BudgetId =
      zio.aws.deadline.model.primitives.BudgetId(impl.budgetId())
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val status: Optional[zio.aws.deadline.model.BudgetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.BudgetStatus.wrap(value))
    override val approximateDollarLimit: Optional[ConsumedUsageLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateDollarLimit())
        .map(value =>
          zio.aws.deadline.model.primitives.ConsumedUsageLimit(value)
        )
    override val actionsToAdd
        : Optional[List[zio.aws.deadline.model.BudgetActionToAdd.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.BudgetActionToAdd.wrap(item)
          }.toList
        )
    override val actionsToRemove
        : Optional[List[zio.aws.deadline.model.BudgetActionToRemove.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.BudgetActionToRemove.wrap(item)
          }.toList
        )
    override val schedule
        : Optional[zio.aws.deadline.model.BudgetSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.deadline.model.BudgetSchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateBudgetRequest
  ): zio.aws.deadline.model.UpdateBudgetRequest.ReadOnly = new Wrapper(impl)
}
