package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{Description, ResourceName, FarmId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFarmRequest(
    farmId: FarmId,
    displayName: Optional[ResourceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateFarmRequest = {
    import UpdateFarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateFarmRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateFarmRequest.ReadOnly =
    zio.aws.deadline.model.UpdateFarmRequest.wrap(buildAwsValue())
}
object UpdateFarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateFarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateFarmRequest =
      zio.aws.deadline.model.UpdateFarmRequest(
        farmId,
        displayName.map(value => value),
        description.map(value => value)
      )
    def farmId: FarmId
    def displayName: Optional[ResourceName]
    def description: Optional[Description]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateFarmRequest
  ) extends zio.aws.deadline.model.UpdateFarmRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateFarmRequest
  ): zio.aws.deadline.model.UpdateFarmRequest.ReadOnly = new Wrapper(impl)
}
