package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  FleetId,
  IamRoleArn,
  FarmId,
  Description,
  ClientToken,
  MinZeroMaxInteger,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class UpdateFleetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    fleetId: FleetId,
    displayName: Optional[ResourceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    minWorkerCount: Optional[MinZeroMaxInteger] = Optional.Absent,
    maxWorkerCount: Optional[MinZeroMaxInteger] = Optional.Absent,
    configuration: Optional[zio.aws.deadline.model.FleetConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateFleetRequest = {
    import UpdateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateFleetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        minWorkerCount.map(value => MinZeroMaxInteger.unwrap(value): Integer)
      )(_.minWorkerCount)
      .optionallyWith(
        maxWorkerCount.map(value => MinZeroMaxInteger.unwrap(value): Integer)
      )(_.maxWorkerCount)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateFleetRequest.ReadOnly =
    zio.aws.deadline.model.UpdateFleetRequest.wrap(buildAwsValue())
}
object UpdateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateFleetRequest =
      zio.aws.deadline.model.UpdateFleetRequest(
        clientToken.map(value => value),
        farmId,
        fleetId,
        displayName.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        minWorkerCount.map(value => value),
        maxWorkerCount.map(value => value),
        configuration.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def fleetId: FleetId
    def displayName: Optional[ResourceName]
    def description: Optional[Description]
    def roleArn: Optional[IamRoleArn]
    def minWorkerCount: Optional[MinZeroMaxInteger]
    def maxWorkerCount: Optional[MinZeroMaxInteger]
    def configuration
        : Optional[zio.aws.deadline.model.FleetConfiguration.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getMinWorkerCount: ZIO[Any, AwsError, MinZeroMaxInteger] =
      AwsError.unwrapOptionField("minWorkerCount", minWorkerCount)
    def getMaxWorkerCount: ZIO[Any, AwsError, MinZeroMaxInteger] =
      AwsError.unwrapOptionField("maxWorkerCount", maxWorkerCount)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.FleetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateFleetRequest
  ) extends zio.aws.deadline.model.UpdateFleetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
    override val minWorkerCount: Optional[MinZeroMaxInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minWorkerCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MinZeroMaxInteger(value)
        )
    override val maxWorkerCount: Optional[MinZeroMaxInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxWorkerCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MinZeroMaxInteger(value)
        )
    override val configuration
        : Optional[zio.aws.deadline.model.FleetConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.deadline.model.FleetConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateFleetRequest
  ): zio.aws.deadline.model.UpdateFleetRequest.ReadOnly = new Wrapper(impl)
}
