package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  MaxFailedTasksCount,
  FarmId,
  JobPriority,
  MaxRetriesPerTask,
  JobId,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class UpdateJobRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.JobTargetTaskRunStatus
    ] = Optional.Absent,
    priority: Optional[JobPriority] = Optional.Absent,
    maxFailedTasksCount: Optional[MaxFailedTasksCount] = Optional.Absent,
    maxRetriesPerTask: Optional[MaxRetriesPerTask] = Optional.Absent,
    lifecycleStatus: Optional[zio.aws.deadline.model.UpdateJobLifecycleStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateJobRequest = {
    import UpdateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .optionallyWith(
        priority.map(value => JobPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        maxFailedTasksCount.map(value =>
          MaxFailedTasksCount.unwrap(value): Integer
        )
      )(_.maxFailedTasksCount)
      .optionallyWith(
        maxRetriesPerTask.map(value => MaxRetriesPerTask.unwrap(value): Integer)
      )(_.maxRetriesPerTask)
      .optionallyWith(lifecycleStatus.map(value => value.unwrap))(
        _.lifecycleStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateJobRequest.ReadOnly =
    zio.aws.deadline.model.UpdateJobRequest.wrap(buildAwsValue())
}
object UpdateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateJobRequest =
      zio.aws.deadline.model.UpdateJobRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        jobId,
        targetTaskRunStatus.map(value => value),
        priority.map(value => value),
        maxFailedTasksCount.map(value => value),
        maxRetriesPerTask.map(value => value),
        lifecycleStatus.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus]
    def priority: Optional[JobPriority]
    def maxFailedTasksCount: Optional[MaxFailedTasksCount]
    def maxRetriesPerTask: Optional[MaxRetriesPerTask]
    def lifecycleStatus
        : Optional[zio.aws.deadline.model.UpdateJobLifecycleStatus]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getTargetTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobTargetTaskRunStatus] =
      AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getPriority: ZIO[Any, AwsError, JobPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxFailedTasksCount: ZIO[Any, AwsError, MaxFailedTasksCount] =
      AwsError.unwrapOptionField("maxFailedTasksCount", maxFailedTasksCount)
    def getMaxRetriesPerTask: ZIO[Any, AwsError, MaxRetriesPerTask] =
      AwsError.unwrapOptionField("maxRetriesPerTask", maxRetriesPerTask)
    def getLifecycleStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.UpdateJobLifecycleStatus] =
      AwsError.unwrapOptionField("lifecycleStatus", lifecycleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateJobRequest
  ) extends zio.aws.deadline.model.UpdateJobRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value => zio.aws.deadline.model.JobTargetTaskRunStatus.wrap(value))
    override val priority: Optional[JobPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.deadline.model.primitives.JobPriority(value))
    override val maxFailedTasksCount: Optional[MaxFailedTasksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxFailedTasksCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxFailedTasksCount(value)
        )
    override val maxRetriesPerTask: Optional[MaxRetriesPerTask] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRetriesPerTask())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxRetriesPerTask(value)
        )
    override val lifecycleStatus
        : Optional[zio.aws.deadline.model.UpdateJobLifecycleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatus())
        .map(value =>
          zio.aws.deadline.model.UpdateJobLifecycleStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateJobRequest
  ): zio.aws.deadline.model.UpdateJobRequest.ReadOnly = new Wrapper(impl)
}
