package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IamRoleArn,
  ResourceName,
  Subdomain,
  MonitorId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMonitorRequest(
    monitorId: MonitorId,
    subdomain: Optional[Subdomain] = Optional.Absent,
    displayName: Optional[ResourceName] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest = {
    import UpdateMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest
      .builder()
      .monitorId(MonitorId.unwrap(monitorId): java.lang.String)
      .optionallyWith(
        subdomain.map(value => Subdomain.unwrap(value): java.lang.String)
      )(_.subdomain)
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateMonitorRequest.ReadOnly =
    zio.aws.deadline.model.UpdateMonitorRequest.wrap(buildAwsValue())
}
object UpdateMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateMonitorRequest =
      zio.aws.deadline.model.UpdateMonitorRequest(
        monitorId,
        subdomain.map(value => value),
        displayName.map(value => value),
        roleArn.map(value => value)
      )
    def monitorId: MonitorId
    def subdomain: Optional[Subdomain]
    def displayName: Optional[ResourceName]
    def roleArn: Optional[IamRoleArn]
    def getMonitorId: ZIO[Any, Nothing, MonitorId] = ZIO.succeed(monitorId)
    def getSubdomain: ZIO[Any, AwsError, Subdomain] =
      AwsError.unwrapOptionField("subdomain", subdomain)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest
  ) extends zio.aws.deadline.model.UpdateMonitorRequest.ReadOnly {
    override val monitorId: MonitorId =
      zio.aws.deadline.model.primitives.MonitorId(impl.monitorId())
    override val subdomain: Optional[Subdomain] = zio.aws.core.internal
      .optionalFromNullable(impl.subdomain())
      .map(value => zio.aws.deadline.model.primitives.Subdomain(value))
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateMonitorRequest
  ): zio.aws.deadline.model.UpdateMonitorRequest.ReadOnly = new Wrapper(impl)
}
