package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueEnvironmentId,
  QueueId,
  FarmId,
  Priority,
  ClientToken,
  EnvironmentTemplate
}
import scala.jdk.CollectionConverters._
final case class UpdateQueueEnvironmentRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    queueEnvironmentId: QueueEnvironmentId,
    priority: Optional[Priority] = Optional.Absent,
    templateType: Optional[zio.aws.deadline.model.EnvironmentTemplateType] =
      Optional.Absent,
    template: Optional[EnvironmentTemplate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest = {
    import UpdateQueueEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .queueEnvironmentId(
        QueueEnvironmentId.unwrap(queueEnvironmentId): java.lang.String
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(templateType.map(value => value.unwrap))(_.templateType)
      .optionallyWith(
        template.map(value =>
          EnvironmentTemplate.unwrap(value): java.lang.String
        )
      )(_.template)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.UpdateQueueEnvironmentRequest.ReadOnly =
    zio.aws.deadline.model.UpdateQueueEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateQueueEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateQueueEnvironmentRequest =
      zio.aws.deadline.model.UpdateQueueEnvironmentRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        queueEnvironmentId,
        priority.map(value => value),
        templateType.map(value => value),
        template.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def queueEnvironmentId: QueueEnvironmentId
    def priority: Optional[Priority]
    def templateType: Optional[zio.aws.deadline.model.EnvironmentTemplateType]
    def template: Optional[EnvironmentTemplate]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getQueueEnvironmentId: ZIO[Any, Nothing, QueueEnvironmentId] =
      ZIO.succeed(queueEnvironmentId)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getTemplateType
        : ZIO[Any, AwsError, zio.aws.deadline.model.EnvironmentTemplateType] =
      AwsError.unwrapOptionField("templateType", templateType)
    def getTemplate: ZIO[Any, AwsError, EnvironmentTemplate] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest
  ) extends zio.aws.deadline.model.UpdateQueueEnvironmentRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val queueEnvironmentId: QueueEnvironmentId =
      zio.aws.deadline.model.primitives
        .QueueEnvironmentId(impl.queueEnvironmentId())
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.deadline.model.primitives.Priority(value))
    override val templateType
        : Optional[zio.aws.deadline.model.EnvironmentTemplateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateType())
        .map(value =>
          zio.aws.deadline.model.EnvironmentTemplateType.wrap(value)
        )
    override val template: Optional[EnvironmentTemplate] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value =>
        zio.aws.deadline.model.primitives.EnvironmentTemplate(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueEnvironmentRequest
  ): zio.aws.deadline.model.UpdateQueueEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
