package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{FleetId, QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateQueueFleetAssociationRequest(
    farmId: FarmId,
    queueId: QueueId,
    fleetId: FleetId,
    status: zio.aws.deadline.model.UpdateQueueFleetAssociationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest = {
    import UpdateQueueFleetAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.UpdateQueueFleetAssociationRequest.ReadOnly =
    zio.aws.deadline.model.UpdateQueueFleetAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateQueueFleetAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateQueueFleetAssociationRequest =
      zio.aws.deadline.model.UpdateQueueFleetAssociationRequest(
        farmId,
        queueId,
        fleetId,
        status
      )
    def farmId: FarmId
    def queueId: QueueId
    def fleetId: FleetId
    def status: zio.aws.deadline.model.UpdateQueueFleetAssociationStatus
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.UpdateQueueFleetAssociationStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest
  ) extends zio.aws.deadline.model.UpdateQueueFleetAssociationRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val status
        : zio.aws.deadline.model.UpdateQueueFleetAssociationStatus =
      zio.aws.deadline.model.UpdateQueueFleetAssociationStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueFleetAssociationRequest
  ): zio.aws.deadline.model.UpdateQueueFleetAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
