package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  QueueId,
  IamRoleArn,
  FarmId,
  FileSystemLocationName,
  StorageProfileId,
  Description,
  ClientToken,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateQueueRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    displayName: Optional[ResourceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    defaultBudgetAction: Optional[
      zio.aws.deadline.model.DefaultQueueBudgetAction
    ] = Optional.Absent,
    jobAttachmentSettings: Optional[
      zio.aws.deadline.model.JobAttachmentSettings
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser] =
      Optional.Absent,
    requiredFileSystemLocationNamesToAdd: Optional[
      Iterable[FileSystemLocationName]
    ] = Optional.Absent,
    requiredFileSystemLocationNamesToRemove: Optional[
      Iterable[FileSystemLocationName]
    ] = Optional.Absent,
    allowedStorageProfileIdsToAdd: Optional[Iterable[StorageProfileId]] =
      Optional.Absent,
    allowedStorageProfileIdsToRemove: Optional[Iterable[StorageProfileId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateQueueRequest = {
    import UpdateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateQueueRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(defaultBudgetAction.map(value => value.unwrap))(
        _.defaultBudgetAction
      )
      .optionallyWith(
        jobAttachmentSettings.map(value => value.buildAwsValue())
      )(_.jobAttachmentSettings)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(jobRunAsUser.map(value => value.buildAwsValue()))(
        _.jobRunAsUser
      )
      .optionallyWith(
        requiredFileSystemLocationNamesToAdd.map(value =>
          value.map { item =>
            FileSystemLocationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredFileSystemLocationNamesToAdd)
      .optionallyWith(
        requiredFileSystemLocationNamesToRemove.map(value =>
          value.map { item =>
            FileSystemLocationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredFileSystemLocationNamesToRemove)
      .optionallyWith(
        allowedStorageProfileIdsToAdd.map(value =>
          value.map { item =>
            StorageProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedStorageProfileIdsToAdd)
      .optionallyWith(
        allowedStorageProfileIdsToRemove.map(value =>
          value.map { item =>
            StorageProfileId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedStorageProfileIdsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateQueueRequest.ReadOnly =
    zio.aws.deadline.model.UpdateQueueRequest.wrap(buildAwsValue())
}
object UpdateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateQueueRequest =
      zio.aws.deadline.model.UpdateQueueRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        displayName.map(value => value),
        description.map(value => value),
        defaultBudgetAction.map(value => value),
        jobAttachmentSettings.map(value => value.asEditable),
        roleArn.map(value => value),
        jobRunAsUser.map(value => value.asEditable),
        requiredFileSystemLocationNamesToAdd.map(value => value),
        requiredFileSystemLocationNamesToRemove.map(value => value),
        allowedStorageProfileIdsToAdd.map(value => value),
        allowedStorageProfileIdsToRemove.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def displayName: Optional[ResourceName]
    def description: Optional[Description]
    def defaultBudgetAction
        : Optional[zio.aws.deadline.model.DefaultQueueBudgetAction]
    def jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly]
    def roleArn: Optional[IamRoleArn]
    def jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly]
    def requiredFileSystemLocationNamesToAdd
        : Optional[List[FileSystemLocationName]]
    def requiredFileSystemLocationNamesToRemove
        : Optional[List[FileSystemLocationName]]
    def allowedStorageProfileIdsToAdd: Optional[List[StorageProfileId]]
    def allowedStorageProfileIdsToRemove: Optional[List[StorageProfileId]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultBudgetAction
        : ZIO[Any, AwsError, zio.aws.deadline.model.DefaultQueueBudgetAction] =
      AwsError.unwrapOptionField("defaultBudgetAction", defaultBudgetAction)
    def getJobAttachmentSettings: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("jobAttachmentSettings", jobAttachmentSettings)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getJobRunAsUser
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      AwsError.unwrapOptionField("jobRunAsUser", jobRunAsUser)
    def getRequiredFileSystemLocationNamesToAdd
        : ZIO[Any, AwsError, List[FileSystemLocationName]] =
      AwsError.unwrapOptionField(
        "requiredFileSystemLocationNamesToAdd",
        requiredFileSystemLocationNamesToAdd
      )
    def getRequiredFileSystemLocationNamesToRemove
        : ZIO[Any, AwsError, List[FileSystemLocationName]] =
      AwsError.unwrapOptionField(
        "requiredFileSystemLocationNamesToRemove",
        requiredFileSystemLocationNamesToRemove
      )
    def getAllowedStorageProfileIdsToAdd
        : ZIO[Any, AwsError, List[StorageProfileId]] =
      AwsError.unwrapOptionField(
        "allowedStorageProfileIdsToAdd",
        allowedStorageProfileIdsToAdd
      )
    def getAllowedStorageProfileIdsToRemove
        : ZIO[Any, AwsError, List[StorageProfileId]] =
      AwsError.unwrapOptionField(
        "allowedStorageProfileIdsToRemove",
        allowedStorageProfileIdsToRemove
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueRequest
  ) extends zio.aws.deadline.model.UpdateQueueRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
    override val defaultBudgetAction
        : Optional[zio.aws.deadline.model.DefaultQueueBudgetAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultBudgetAction())
        .map(value =>
          zio.aws.deadline.model.DefaultQueueBudgetAction.wrap(value)
        )
    override val jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentSettings())
        .map(value => zio.aws.deadline.model.JobAttachmentSettings.wrap(value))
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
    override val jobRunAsUser
        : Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobRunAsUser())
        .map(value => zio.aws.deadline.model.JobRunAsUser.wrap(value))
    override val requiredFileSystemLocationNamesToAdd
        : Optional[List[FileSystemLocationName]] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredFileSystemLocationNamesToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.FileSystemLocationName(item)
        }.toList
      )
    override val requiredFileSystemLocationNamesToRemove
        : Optional[List[FileSystemLocationName]] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredFileSystemLocationNamesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.FileSystemLocationName(item)
        }.toList
      )
    override val allowedStorageProfileIdsToAdd
        : Optional[List[StorageProfileId]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedStorageProfileIdsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.StorageProfileId(item)
        }.toList
      )
    override val allowedStorageProfileIdsToRemove
        : Optional[List[StorageProfileId]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedStorageProfileIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.deadline.model.primitives.StorageProfileId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateQueueRequest
  ): zio.aws.deadline.model.UpdateQueueRequest.ReadOnly = new Wrapper(impl)
}
