package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  JobId,
  ClientToken,
  SessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSessionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    sessionId: SessionId,
    targetLifecycleStatus: zio.aws.deadline.model.SessionLifecycleTargetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateSessionRequest = {
    import UpdateSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateSessionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .targetLifecycleStatus(targetLifecycleStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateSessionRequest.ReadOnly =
    zio.aws.deadline.model.UpdateSessionRequest.wrap(buildAwsValue())
}
object UpdateSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateSessionRequest =
      zio.aws.deadline.model.UpdateSessionRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        jobId,
        sessionId,
        targetLifecycleStatus
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def sessionId: SessionId
    def targetLifecycleStatus
        : zio.aws.deadline.model.SessionLifecycleTargetStatus
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getTargetLifecycleStatus: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.SessionLifecycleTargetStatus
    ] = ZIO.succeed(targetLifecycleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateSessionRequest
  ) extends zio.aws.deadline.model.UpdateSessionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val sessionId: SessionId =
      zio.aws.deadline.model.primitives.SessionId(impl.sessionId())
    override val targetLifecycleStatus
        : zio.aws.deadline.model.SessionLifecycleTargetStatus =
      zio.aws.deadline.model.SessionLifecycleTargetStatus
        .wrap(impl.targetLifecycleStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateSessionRequest
  ): zio.aws.deadline.model.UpdateSessionRequest.ReadOnly = new Wrapper(impl)
}
