package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  StepId,
  JobId,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStepRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    stepId: StepId,
    targetTaskRunStatus: zio.aws.deadline.model.StepTargetTaskRunStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateStepRequest = {
    import UpdateStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateStepRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .targetTaskRunStatus(targetTaskRunStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateStepRequest.ReadOnly =
    zio.aws.deadline.model.UpdateStepRequest.wrap(buildAwsValue())
}
object UpdateStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateStepRequest =
      zio.aws.deadline.model.UpdateStepRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        jobId,
        stepId,
        targetTaskRunStatus
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def stepId: StepId
    def targetTaskRunStatus: zio.aws.deadline.model.StepTargetTaskRunStatus
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getTargetTaskRunStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.StepTargetTaskRunStatus] =
      ZIO.succeed(targetTaskRunStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateStepRequest
  ) extends zio.aws.deadline.model.UpdateStepRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val targetTaskRunStatus
        : zio.aws.deadline.model.StepTargetTaskRunStatus =
      zio.aws.deadline.model.StepTargetTaskRunStatus
        .wrap(impl.targetTaskRunStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateStepRequest
  ): zio.aws.deadline.model.UpdateStepRequest.ReadOnly = new Wrapper(impl)
}
