package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  ResourceName,
  StorageProfileId,
  FarmId,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStorageProfileRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    storageProfileId: StorageProfileId,
    displayName: Optional[ResourceName] = Optional.Absent,
    osFamily: Optional[
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = Optional.Absent,
    fileSystemLocationsToAdd: Optional[
      Iterable[zio.aws.deadline.model.FileSystemLocation]
    ] = Optional.Absent,
    fileSystemLocationsToRemove: Optional[
      Iterable[zio.aws.deadline.model.FileSystemLocation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest = {
    import UpdateStorageProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .storageProfileId(
        StorageProfileId.unwrap(storageProfileId): java.lang.String
      )
      .optionallyWith(
        displayName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(osFamily.map(value => value.unwrap))(_.osFamily)
      .optionallyWith(
        fileSystemLocationsToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocationsToAdd)
      .optionallyWith(
        fileSystemLocationsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocationsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateStorageProfileRequest.ReadOnly =
    zio.aws.deadline.model.UpdateStorageProfileRequest.wrap(buildAwsValue())
}
object UpdateStorageProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateStorageProfileRequest =
      zio.aws.deadline.model.UpdateStorageProfileRequest(
        clientToken.map(value => value),
        farmId,
        storageProfileId,
        displayName.map(value => value),
        osFamily.map(value => value),
        fileSystemLocationsToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileSystemLocationsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def storageProfileId: StorageProfileId
    def displayName: Optional[ResourceName]
    def osFamily
        : Optional[zio.aws.deadline.model.StorageProfileOperatingSystemFamily]
    def fileSystemLocationsToAdd
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]]
    def fileSystemLocationsToRemove
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getStorageProfileId: ZIO[Any, Nothing, StorageProfileId] =
      ZIO.succeed(storageProfileId)
    def getDisplayName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getOsFamily: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.StorageProfileOperatingSystemFamily
    ] = AwsError.unwrapOptionField("osFamily", osFamily)
    def getFileSystemLocationsToAdd: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fileSystemLocationsToAdd",
      fileSystemLocationsToAdd
    )
    def getFileSystemLocationsToRemove: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.FileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fileSystemLocationsToRemove",
      fileSystemLocationsToRemove
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest
  ) extends zio.aws.deadline.model.UpdateStorageProfileRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val storageProfileId: StorageProfileId =
      zio.aws.deadline.model.primitives
        .StorageProfileId(impl.storageProfileId())
    override val displayName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.deadline.model.primitives.ResourceName(value))
    override val osFamily
        : Optional[zio.aws.deadline.model.StorageProfileOperatingSystemFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osFamily())
        .map(value =>
          zio.aws.deadline.model.StorageProfileOperatingSystemFamily.wrap(value)
        )
    override val fileSystemLocationsToAdd
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocationsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.FileSystemLocation.wrap(item)
          }.toList
        )
    override val fileSystemLocationsToRemove
        : Optional[List[zio.aws.deadline.model.FileSystemLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocationsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.FileSystemLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateStorageProfileRequest
  ): zio.aws.deadline.model.UpdateStorageProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
