package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  StepId,
  JobId,
  ClientToken,
  TaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTaskRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    stepId: StepId,
    taskId: TaskId,
    targetRunStatus: zio.aws.deadline.model.TaskTargetRunStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateTaskRequest = {
    import UpdateTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateTaskRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .targetRunStatus(targetRunStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateTaskRequest.ReadOnly =
    zio.aws.deadline.model.UpdateTaskRequest.wrap(buildAwsValue())
}
object UpdateTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateTaskRequest =
      zio.aws.deadline.model.UpdateTaskRequest(
        clientToken.map(value => value),
        farmId,
        queueId,
        jobId,
        stepId,
        taskId,
        targetRunStatus
      )
    def clientToken: Optional[ClientToken]
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def stepId: StepId
    def taskId: TaskId
    def targetRunStatus: zio.aws.deadline.model.TaskTargetRunStatus
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getTargetRunStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.TaskTargetRunStatus] =
      ZIO.succeed(targetRunStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateTaskRequest
  ) extends zio.aws.deadline.model.UpdateTaskRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.deadline.model.primitives.ClientToken(value))
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
    override val targetRunStatus: zio.aws.deadline.model.TaskTargetRunStatus =
      zio.aws.deadline.model.TaskTargetRunStatus.wrap(impl.targetRunStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateTaskRequest
  ): zio.aws.deadline.model.UpdateTaskRequest.ReadOnly = new Wrapper(impl)
}
