package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{WorkerId, FleetId, FarmId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWorkerRequest(
    farmId: FarmId,
    fleetId: FleetId,
    workerId: WorkerId,
    status: Optional[zio.aws.deadline.model.UpdatedWorkerStatus] =
      Optional.Absent,
    capabilities: Optional[zio.aws.deadline.model.WorkerCapabilities] =
      Optional.Absent,
    hostProperties: Optional[zio.aws.deadline.model.HostPropertiesRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest = {
    import UpdateWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateWorkerRequest.ReadOnly =
    zio.aws.deadline.model.UpdateWorkerRequest.wrap(buildAwsValue())
}
object UpdateWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateWorkerRequest =
      zio.aws.deadline.model.UpdateWorkerRequest(
        farmId,
        fleetId,
        workerId,
        status.map(value => value),
        capabilities.map(value => value.asEditable),
        hostProperties.map(value => value.asEditable)
      )
    def farmId: FarmId
    def fleetId: FleetId
    def workerId: WorkerId
    def status: Optional[zio.aws.deadline.model.UpdatedWorkerStatus]
    def capabilities
        : Optional[zio.aws.deadline.model.WorkerCapabilities.ReadOnly]
    def hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesRequest.ReadOnly]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.UpdatedWorkerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.WorkerCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getHostProperties: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.HostPropertiesRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hostProperties", hostProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest
  ) extends zio.aws.deadline.model.UpdateWorkerRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val status: Optional[zio.aws.deadline.model.UpdatedWorkerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.UpdatedWorkerStatus.wrap(value))
    override val capabilities
        : Optional[zio.aws.deadline.model.WorkerCapabilities.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value => zio.aws.deadline.model.WorkerCapabilities.wrap(value))
    override val hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostProperties())
        .map(value => zio.aws.deadline.model.HostPropertiesRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerRequest
  ): zio.aws.deadline.model.UpdateWorkerRequest.ReadOnly = new Wrapper(impl)
}
