package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWorkerResponse(
    log: Optional[zio.aws.deadline.model.LogConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse = {
    import UpdateWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse
      .builder()
      .optionallyWith(log.map(value => value.buildAwsValue()))(_.log)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly =
    zio.aws.deadline.model.UpdateWorkerResponse.wrap(buildAwsValue())
}
object UpdateWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateWorkerResponse =
      zio.aws.deadline.model
        .UpdateWorkerResponse(log.map(value => value.asEditable))
    def log: Optional[zio.aws.deadline.model.LogConfiguration.ReadOnly]
    def getLog
        : ZIO[Any, AwsError, zio.aws.deadline.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("log", log)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse
  ) extends zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly {
    override val log
        : Optional[zio.aws.deadline.model.LogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.log())
        .map(value => zio.aws.deadline.model.LogConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerResponse
  ): zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly = new Wrapper(impl)
}
