package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  SessionActionId,
  WorkerId,
  FleetId,
  FarmId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWorkerScheduleRequest(
    farmId: FarmId,
    fleetId: FleetId,
    workerId: WorkerId,
    updatedSessionActions: Optional[
      Map[SessionActionId, zio.aws.deadline.model.UpdatedSessionActionInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest = {
    import UpdateWorkerScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .optionallyWith(
        updatedSessionActions.map(value =>
          value
            .map({ case (key, value) =>
              (SessionActionId.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.updatedSessionActions)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateWorkerScheduleRequest.ReadOnly =
    zio.aws.deadline.model.UpdateWorkerScheduleRequest.wrap(buildAwsValue())
}
object UpdateWorkerScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateWorkerScheduleRequest =
      zio.aws.deadline.model.UpdateWorkerScheduleRequest(
        farmId,
        fleetId,
        workerId,
        updatedSessionActions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def farmId: FarmId
    def fleetId: FleetId
    def workerId: WorkerId
    def updatedSessionActions: Optional[Map[
      SessionActionId,
      zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly
    ]]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getUpdatedSessionActions: ZIO[Any, AwsError, Map[
      SessionActionId,
      zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("updatedSessionActions", updatedSessionActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest
  ) extends zio.aws.deadline.model.UpdateWorkerScheduleRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val updatedSessionActions: Optional[Map[
      SessionActionId,
      zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedSessionActions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.deadline.model.primitives.SessionActionId(
              key
            ) -> zio.aws.deadline.model.UpdatedSessionActionInfo.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleRequest
  ): zio.aws.deadline.model.UpdateWorkerScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
