package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  UpdateWorkerScheduleInterval,
  SessionActionId,
  SessionId
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkerScheduleResponse(
    assignedSessions: Map[SessionId, zio.aws.deadline.model.AssignedSession],
    cancelSessionActions: Map[SessionId, Iterable[SessionActionId]],
    desiredWorkerStatus: Optional[zio.aws.deadline.model.DesiredWorkerStatus] =
      Optional.Absent,
    updateIntervalSeconds: UpdateWorkerScheduleInterval
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse = {
    import UpdateWorkerScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse
      .builder()
      .assignedSessions(
        assignedSessions
          .map({ case (key, value) =>
            (SessionId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .cancelSessionActions(
        cancelSessionActions
          .map({ case (key, value) =>
            (SessionId.unwrap(key): java.lang.String) -> value.map { item =>
              SessionActionId.unwrap(item): java.lang.String
            }.asJavaCollection
          })
          .asJava
      )
      .optionallyWith(desiredWorkerStatus.map(value => value.unwrap))(
        _.desiredWorkerStatus
      )
      .updateIntervalSeconds(
        UpdateWorkerScheduleInterval.unwrap(updateIntervalSeconds): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly =
    zio.aws.deadline.model.UpdateWorkerScheduleResponse.wrap(buildAwsValue())
}
object UpdateWorkerScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdateWorkerScheduleResponse =
      zio.aws.deadline.model.UpdateWorkerScheduleResponse(
        assignedSessions.map({ case (key, value) =>
          key -> value.asEditable
        }),
        cancelSessionActions,
        desiredWorkerStatus.map(value => value),
        updateIntervalSeconds
      )
    def assignedSessions
        : Map[SessionId, zio.aws.deadline.model.AssignedSession.ReadOnly]
    def cancelSessionActions: Map[SessionId, List[SessionActionId]]
    def desiredWorkerStatus
        : Optional[zio.aws.deadline.model.DesiredWorkerStatus]
    def updateIntervalSeconds: UpdateWorkerScheduleInterval
    def getAssignedSessions: ZIO[Any, Nothing, Map[
      SessionId,
      zio.aws.deadline.model.AssignedSession.ReadOnly
    ]] = ZIO.succeed(assignedSessions)
    def getCancelSessionActions
        : ZIO[Any, Nothing, Map[SessionId, List[SessionActionId]]] =
      ZIO.succeed(cancelSessionActions)
    def getDesiredWorkerStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.DesiredWorkerStatus] =
      AwsError.unwrapOptionField("desiredWorkerStatus", desiredWorkerStatus)
    def getUpdateIntervalSeconds
        : ZIO[Any, Nothing, UpdateWorkerScheduleInterval] =
      ZIO.succeed(updateIntervalSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse
  ) extends zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly {
    override val assignedSessions
        : Map[SessionId, zio.aws.deadline.model.AssignedSession.ReadOnly] = impl
      .assignedSessions()
      .asScala
      .map({ case (key, value) =>
        zio.aws.deadline.model.primitives
          .SessionId(key) -> zio.aws.deadline.model.AssignedSession.wrap(value)
      })
      .toMap
    override val cancelSessionActions: Map[SessionId, List[SessionActionId]] =
      impl
        .cancelSessionActions()
        .asScala
        .map({ case (key, value) =>
          zio.aws.deadline.model.primitives
            .SessionId(key) -> value.asScala.map { item =>
            zio.aws.deadline.model.primitives.SessionActionId(item)
          }.toList
        })
        .toMap
    override val desiredWorkerStatus
        : Optional[zio.aws.deadline.model.DesiredWorkerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredWorkerStatus())
        .map(value => zio.aws.deadline.model.DesiredWorkerStatus.wrap(value))
    override val updateIntervalSeconds: UpdateWorkerScheduleInterval =
      zio.aws.deadline.model.primitives
        .UpdateWorkerScheduleInterval(impl.updateIntervalSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdateWorkerScheduleResponse
  ): zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly = new Wrapper(
    impl
  )
}
