package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  SessionActionProgressPercent,
  SyntheticTimestamp_date_time,
  SessionActionProgressMessage,
  ProcessExitCode
}
import scala.jdk.CollectionConverters._
final case class UpdatedSessionActionInfo(
    completedStatus: Optional[zio.aws.deadline.model.CompletedStatus] =
      Optional.Absent,
    processExitCode: Optional[ProcessExitCode] = Optional.Absent,
    progressMessage: Optional[SessionActionProgressMessage] = Optional.Absent,
    startedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    endedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    progressPercent: Optional[SessionActionProgressPercent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo = {
    import UpdatedSessionActionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo
      .builder()
      .optionallyWith(completedStatus.map(value => value.unwrap))(
        _.completedStatus
      )
      .optionallyWith(
        processExitCode.map(value => ProcessExitCode.unwrap(value): Integer)
      )(_.processExitCode)
      .optionallyWith(
        progressMessage.map(value =>
          SessionActionProgressMessage.unwrap(value): java.lang.String
        )
      )(_.progressMessage)
      .optionallyWith(
        startedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.startedAt)
      .optionallyWith(
        endedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endedAt)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .optionallyWith(
        progressPercent.map(value =>
          SessionActionProgressPercent.unwrap(value): java.lang.Float
        )
      )(_.progressPercent)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly =
    zio.aws.deadline.model.UpdatedSessionActionInfo.wrap(buildAwsValue())
}
object UpdatedSessionActionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UpdatedSessionActionInfo =
      zio.aws.deadline.model.UpdatedSessionActionInfo(
        completedStatus.map(value => value),
        processExitCode.map(value => value),
        progressMessage.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value),
        updatedAt.map(value => value),
        progressPercent.map(value => value)
      )
    def completedStatus: Optional[zio.aws.deadline.model.CompletedStatus]
    def processExitCode: Optional[ProcessExitCode]
    def progressMessage: Optional[SessionActionProgressMessage]
    def startedAt: Optional[SyntheticTimestamp_date_time]
    def endedAt: Optional[SyntheticTimestamp_date_time]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def progressPercent: Optional[SessionActionProgressPercent]
    def getCompletedStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.CompletedStatus] =
      AwsError.unwrapOptionField("completedStatus", completedStatus)
    def getProcessExitCode: ZIO[Any, AwsError, ProcessExitCode] =
      AwsError.unwrapOptionField("processExitCode", processExitCode)
    def getProgressMessage: ZIO[Any, AwsError, SessionActionProgressMessage] =
      AwsError.unwrapOptionField("progressMessage", progressMessage)
    def getStartedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getProgressPercent: ZIO[Any, AwsError, SessionActionProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo
  ) extends zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly {
    override val completedStatus
        : Optional[zio.aws.deadline.model.CompletedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completedStatus())
        .map(value => zio.aws.deadline.model.CompletedStatus.wrap(value))
    override val processExitCode: Optional[ProcessExitCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processExitCode())
        .map(value => zio.aws.deadline.model.primitives.ProcessExitCode(value))
    override val progressMessage: Optional[SessionActionProgressMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressMessage())
        .map(value =>
          zio.aws.deadline.model.primitives.SessionActionProgressMessage(value)
        )
    override val startedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startedAt())
        .map(value =>
          zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val endedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endedAt())
        .map(value =>
          zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val progressPercent: Optional[SessionActionProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value =>
          zio.aws.deadline.model.primitives.SessionActionProgressPercent(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UpdatedSessionActionInfo
  ): zio.aws.deadline.model.UpdatedSessionActionInfo.ReadOnly = new Wrapper(
    impl
  )
}
