package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait UpdatedWorkerStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus
}
object UpdatedWorkerStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus
  ): zio.aws.deadline.model.UpdatedWorkerStatus = value match {
    case software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.UpdatedWorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus =
      software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTED extends zio.aws.deadline.model.UpdatedWorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus =
      software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STARTED
  }
  case object STOPPING extends zio.aws.deadline.model.UpdatedWorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus =
      software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STOPPING
  }
  case object STOPPED extends zio.aws.deadline.model.UpdatedWorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus =
      software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus.STOPPED
  }
}
