package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait UsageStatistic {
  def unwrap: software.amazon.awssdk.services.deadline.model.UsageStatistic
}
object UsageStatistic {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.UsageStatistic
  ): zio.aws.deadline.model.UsageStatistic = value match {
    case software.amazon.awssdk.services.deadline.model.UsageStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.UsageStatistic.SUM =>
      val r = SUM
      r
    case software.amazon.awssdk.services.deadline.model.UsageStatistic.MIN =>
      val r = MIN
      r
    case software.amazon.awssdk.services.deadline.model.UsageStatistic.MAX =>
      val r = MAX
      r
    case software.amazon.awssdk.services.deadline.model.UsageStatistic.AVG =>
      val r = AVG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.UsageStatistic {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageStatistic =
      software.amazon.awssdk.services.deadline.model.UsageStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object SUM extends zio.aws.deadline.model.UsageStatistic {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageStatistic =
      software.amazon.awssdk.services.deadline.model.UsageStatistic.SUM
  }
  case object MIN extends zio.aws.deadline.model.UsageStatistic {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageStatistic =
      software.amazon.awssdk.services.deadline.model.UsageStatistic.MIN
  }
  case object MAX extends zio.aws.deadline.model.UsageStatistic {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageStatistic =
      software.amazon.awssdk.services.deadline.model.UsageStatistic.MAX
  }
  case object AVG extends zio.aws.deadline.model.UsageStatistic {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageStatistic =
      software.amazon.awssdk.services.deadline.model.UsageStatistic.AVG
  }
}
