package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.QueueId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UsageTrackingResource(
    queueId: Optional[QueueId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.UsageTrackingResource = {
    import UsageTrackingResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.UsageTrackingResource
      .builder()
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.UsageTrackingResource.ReadOnly =
    zio.aws.deadline.model.UsageTrackingResource.wrap(buildAwsValue())
}
object UsageTrackingResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.UsageTrackingResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.UsageTrackingResource =
      zio.aws.deadline.model.UsageTrackingResource(queueId.map(value => value))
    def queueId: Optional[QueueId]
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.UsageTrackingResource
  ) extends zio.aws.deadline.model.UsageTrackingResource.ReadOnly {
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.UsageTrackingResource
  ): zio.aws.deadline.model.UsageTrackingResource.ReadOnly = new Wrapper(impl)
}
