package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait UsageType {
  def unwrap: software.amazon.awssdk.services.deadline.model.UsageType
}
object UsageType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.UsageType
  ): zio.aws.deadline.model.UsageType = value match {
    case software.amazon.awssdk.services.deadline.model.UsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.UsageType.COMPUTE =>
      val r = COMPUTE
      r
    case software.amazon.awssdk.services.deadline.model.UsageType.LICENSE =>
      val r = LICENSE
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageType =
      software.amazon.awssdk.services.deadline.model.UsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPUTE extends zio.aws.deadline.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageType =
      software.amazon.awssdk.services.deadline.model.UsageType.COMPUTE
  }
  case object LICENSE extends zio.aws.deadline.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.UsageType =
      software.amazon.awssdk.services.deadline.model.UsageType.LICENSE
  }
}
