package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.MinOneMaxTenThousand
import scala.jdk.CollectionConverters._
final case class VCpuCountRange(
    min: MinOneMaxTenThousand,
    max: Optional[MinOneMaxTenThousand] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.VCpuCountRange = {
    import VCpuCountRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.VCpuCountRange
      .builder()
      .min(MinOneMaxTenThousand.unwrap(min): Integer)
      .optionallyWith(
        max.map(value => MinOneMaxTenThousand.unwrap(value): Integer)
      )(_.max)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.VCpuCountRange.ReadOnly =
    zio.aws.deadline.model.VCpuCountRange.wrap(buildAwsValue())
}
object VCpuCountRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.VCpuCountRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.VCpuCountRange =
      zio.aws.deadline.model.VCpuCountRange(min, max.map(value => value))
    def min: MinOneMaxTenThousand
    def max: Optional[MinOneMaxTenThousand]
    def getMin: ZIO[Any, Nothing, MinOneMaxTenThousand] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, MinOneMaxTenThousand] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.VCpuCountRange
  ) extends zio.aws.deadline.model.VCpuCountRange.ReadOnly {
    override val min: MinOneMaxTenThousand =
      zio.aws.deadline.model.primitives.MinOneMaxTenThousand(impl.min())
    override val max: Optional[MinOneMaxTenThousand] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value =>
        zio.aws.deadline.model.primitives.MinOneMaxTenThousand(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.VCpuCountRange
  ): zio.aws.deadline.model.VCpuCountRange.ReadOnly = new Wrapper(impl)
}
