package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  WindowsUserPasswordArnString,
  WindowsUserUserString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WindowsUser(
    user: WindowsUserUserString,
    passwordArn: WindowsUserPasswordArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WindowsUser = {
    import WindowsUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WindowsUser
      .builder()
      .user(WindowsUserUserString.unwrap(user): java.lang.String)
      .passwordArn(
        WindowsUserPasswordArnString.unwrap(passwordArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WindowsUser.ReadOnly =
    zio.aws.deadline.model.WindowsUser.wrap(buildAwsValue())
}
object WindowsUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WindowsUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WindowsUser =
      zio.aws.deadline.model.WindowsUser(user, passwordArn)
    def user: WindowsUserUserString
    def passwordArn: WindowsUserPasswordArnString
    def getUser: ZIO[Any, Nothing, WindowsUserUserString] = ZIO.succeed(user)
    def getPasswordArn: ZIO[Any, Nothing, WindowsUserPasswordArnString] =
      ZIO.succeed(passwordArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WindowsUser
  ) extends zio.aws.deadline.model.WindowsUser.ReadOnly {
    override val user: WindowsUserUserString =
      zio.aws.deadline.model.primitives.WindowsUserUserString(impl.user())
    override val passwordArn: WindowsUserPasswordArnString =
      zio.aws.deadline.model.primitives
        .WindowsUserPasswordArnString(impl.passwordArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WindowsUser
  ): zio.aws.deadline.model.WindowsUser.ReadOnly = new Wrapper(impl)
}
