package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.AmountCapabilityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WorkerAmountCapability(
    name: AmountCapabilityName,
    value: Float
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerAmountCapability = {
    import WorkerAmountCapability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerAmountCapability
      .builder()
      .name(AmountCapabilityName.unwrap(name): java.lang.String)
      .value(value: java.lang.Float)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerAmountCapability.ReadOnly =
    zio.aws.deadline.model.WorkerAmountCapability.wrap(buildAwsValue())
}
object WorkerAmountCapability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerAmountCapability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerAmountCapability =
      zio.aws.deadline.model.WorkerAmountCapability(name, value)
    def name: AmountCapabilityName
    def value: Float
    def getName: ZIO[Any, Nothing, AmountCapabilityName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, Float] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerAmountCapability
  ) extends zio.aws.deadline.model.WorkerAmountCapability.ReadOnly {
    override val name: AmountCapabilityName =
      zio.aws.deadline.model.primitives.AmountCapabilityName(impl.name())
    override val value: Float = impl.value(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerAmountCapability
  ): zio.aws.deadline.model.WorkerAmountCapability.ReadOnly = new Wrapper(impl)
}
