package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  AttributeCapabilityValue,
  AttributeCapabilityName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WorkerAttributeCapability(
    name: AttributeCapabilityName,
    values: Iterable[AttributeCapabilityValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability = {
    import WorkerAttributeCapability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability
      .builder()
      .name(AttributeCapabilityName.unwrap(name): java.lang.String)
      .values(values.map { item =>
        AttributeCapabilityValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly =
    zio.aws.deadline.model.WorkerAttributeCapability.wrap(buildAwsValue())
}
object WorkerAttributeCapability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerAttributeCapability =
      zio.aws.deadline.model.WorkerAttributeCapability(name, values)
    def name: AttributeCapabilityName
    def values: List[AttributeCapabilityValue]
    def getName: ZIO[Any, Nothing, AttributeCapabilityName] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[AttributeCapabilityValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability
  ) extends zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly {
    override val name: AttributeCapabilityName =
      zio.aws.deadline.model.primitives.AttributeCapabilityName(impl.name())
    override val values: List[AttributeCapabilityValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.deadline.model.primitives.AttributeCapabilityValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability
  ): zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly = new Wrapper(
    impl
  )
}
