package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WorkerCapabilities(
    amounts: Iterable[zio.aws.deadline.model.WorkerAmountCapability],
    attributes: Iterable[zio.aws.deadline.model.WorkerAttributeCapability]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerCapabilities = {
    import WorkerCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerCapabilities
      .builder()
      .amounts(amounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerCapabilities.ReadOnly =
    zio.aws.deadline.model.WorkerCapabilities.wrap(buildAwsValue())
}
object WorkerCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerCapabilities =
      zio.aws.deadline.model.WorkerCapabilities(
        amounts.map { item =>
          item.asEditable
        },
        attributes.map { item =>
          item.asEditable
        }
      )
    def amounts: List[zio.aws.deadline.model.WorkerAmountCapability.ReadOnly]
    def attributes
        : List[zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly]
    def getAmounts: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.WorkerAmountCapability.ReadOnly
    ]] = ZIO.succeed(amounts)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerCapabilities
  ) extends zio.aws.deadline.model.WorkerCapabilities.ReadOnly {
    override val amounts
        : List[zio.aws.deadline.model.WorkerAmountCapability.ReadOnly] = impl
      .amounts()
      .asScala
      .map { item =>
        zio.aws.deadline.model.WorkerAmountCapability.wrap(item)
      }
      .toList
    override val attributes
        : List[zio.aws.deadline.model.WorkerAttributeCapability.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.deadline.model.WorkerAttributeCapability.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerCapabilities
  ): zio.aws.deadline.model.WorkerCapabilities.ReadOnly = new Wrapper(impl)
}
