package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  FleetId,
  UpdatedBy,
  WorkerId,
  CreatedAt,
  CreatedBy,
  UpdatedAt
}
import scala.jdk.CollectionConverters._
final case class WorkerSearchSummary(
    fleetId: Optional[FleetId] = Optional.Absent,
    workerId: Optional[WorkerId] = Optional.Absent,
    status: Optional[zio.aws.deadline.model.WorkerStatus] = Optional.Absent,
    hostProperties: Optional[zio.aws.deadline.model.HostPropertiesResponse] =
      Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerSearchSummary = {
    import WorkerSearchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerSearchSummary
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        workerId.map(value => WorkerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerSearchSummary.ReadOnly =
    zio.aws.deadline.model.WorkerSearchSummary.wrap(buildAwsValue())
}
object WorkerSearchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerSearchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerSearchSummary =
      zio.aws.deadline.model.WorkerSearchSummary(
        fleetId.map(value => value),
        workerId.map(value => value),
        status.map(value => value),
        hostProperties.map(value => value.asEditable),
        createdBy.map(value => value),
        createdAt.map(value => value),
        updatedBy.map(value => value),
        updatedAt.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def workerId: Optional[WorkerId]
    def status: Optional[zio.aws.deadline.model.WorkerStatus]
    def hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesResponse.ReadOnly]
    def createdBy: Optional[CreatedBy]
    def createdAt: Optional[CreatedAt]
    def updatedBy: Optional[UpdatedBy]
    def updatedAt: Optional[UpdatedAt]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getWorkerId: ZIO[Any, AwsError, WorkerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getStatus: ZIO[Any, AwsError, zio.aws.deadline.model.WorkerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getHostProperties: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.HostPropertiesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("hostProperties", hostProperties)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSearchSummary
  ) extends zio.aws.deadline.model.WorkerSearchSummary.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.deadline.model.primitives.FleetId(value))
    override val workerId: Optional[WorkerId] = zio.aws.core.internal
      .optionalFromNullable(impl.workerId())
      .map(value => zio.aws.deadline.model.primitives.WorkerId(value))
    override val status: Optional[zio.aws.deadline.model.WorkerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.WorkerStatus.wrap(value))
    override val hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostProperties())
        .map(value => zio.aws.deadline.model.HostPropertiesResponse.wrap(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.deadline.model.primitives.CreatedBy(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.deadline.model.primitives.CreatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSearchSummary
  ): zio.aws.deadline.model.WorkerSearchSummary.ReadOnly = new Wrapper(impl)
}
