package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  QueueId,
  EndedAt,
  JobId,
  StartedAt,
  SessionId
}
import scala.jdk.CollectionConverters._
final case class WorkerSessionSummary(
    sessionId: SessionId,
    queueId: QueueId,
    jobId: JobId,
    startedAt: StartedAt,
    lifecycleStatus: zio.aws.deadline.model.SessionLifecycleStatus,
    endedAt: Optional[EndedAt] = Optional.Absent,
    targetLifecycleStatus: Optional[
      zio.aws.deadline.model.SessionLifecycleTargetStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerSessionSummary = {
    import WorkerSessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerSessionSummary
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .startedAt(StartedAt.unwrap(startedAt): Instant)
      .lifecycleStatus(lifecycleStatus.unwrap)
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(targetLifecycleStatus.map(value => value.unwrap))(
        _.targetLifecycleStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerSessionSummary.ReadOnly =
    zio.aws.deadline.model.WorkerSessionSummary.wrap(buildAwsValue())
}
object WorkerSessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerSessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerSessionSummary =
      zio.aws.deadline.model.WorkerSessionSummary(
        sessionId,
        queueId,
        jobId,
        startedAt,
        lifecycleStatus,
        endedAt.map(value => value),
        targetLifecycleStatus.map(value => value)
      )
    def sessionId: SessionId
    def queueId: QueueId
    def jobId: JobId
    def startedAt: StartedAt
    def lifecycleStatus: zio.aws.deadline.model.SessionLifecycleStatus
    def endedAt: Optional[EndedAt]
    def targetLifecycleStatus
        : Optional[zio.aws.deadline.model.SessionLifecycleTargetStatus]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStartedAt: ZIO[Any, Nothing, StartedAt] = ZIO.succeed(startedAt)
    def getLifecycleStatus
        : ZIO[Any, Nothing, zio.aws.deadline.model.SessionLifecycleStatus] =
      ZIO.succeed(lifecycleStatus)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getTargetLifecycleStatus: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.SessionLifecycleTargetStatus
    ] =
      AwsError.unwrapOptionField("targetLifecycleStatus", targetLifecycleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSessionSummary
  ) extends zio.aws.deadline.model.WorkerSessionSummary.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.deadline.model.primitives.SessionId(impl.sessionId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val startedAt: StartedAt =
      zio.aws.deadline.model.primitives.StartedAt(impl.startedAt())
    override val lifecycleStatus
        : zio.aws.deadline.model.SessionLifecycleStatus =
      zio.aws.deadline.model.SessionLifecycleStatus.wrap(impl.lifecycleStatus())
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val targetLifecycleStatus
        : Optional[zio.aws.deadline.model.SessionLifecycleTargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLifecycleStatus())
        .map(value =>
          zio.aws.deadline.model.SessionLifecycleTargetStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSessionSummary
  ): zio.aws.deadline.model.WorkerSessionSummary.ReadOnly = new Wrapper(impl)
}
