package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait WorkerStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.WorkerStatus
}
object WorkerStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.WorkerStatus
  ): zio.aws.deadline.model.WorkerStatus = value match {
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.NOT_RESPONDING =>
      val r = NOT_RESPONDING
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.NOT_COMPATIBLE =>
      val r = NOT_COMPATIBLE
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.deadline.model.WorkerStatus.IDLE =>
      val r = IDLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.CREATED
  }
  case object STARTED extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.STARTED
  }
  case object STOPPING extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.STOPPING
  }
  case object STOPPED extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.STOPPED
  }
  case object NOT_RESPONDING extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.NOT_RESPONDING
  }
  case object NOT_COMPATIBLE extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.NOT_COMPATIBLE
  }
  case object RUNNING extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.RUNNING
  }
  case object IDLE extends zio.aws.deadline.model.WorkerStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.WorkerStatus =
      software.amazon.awssdk.services.deadline.model.WorkerStatus.IDLE
  }
}
