package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.deadline.model.primitives.{
  FleetId,
  FarmId,
  UpdatedBy,
  WorkerId,
  CreatedAt,
  CreatedBy,
  UpdatedAt
}
import scala.jdk.CollectionConverters._
final case class WorkerSummary(
    workerId: WorkerId,
    farmId: FarmId,
    fleetId: FleetId,
    status: zio.aws.deadline.model.WorkerStatus,
    hostProperties: Optional[zio.aws.deadline.model.HostPropertiesResponse] =
      Optional.Absent,
    log: Optional[zio.aws.deadline.model.LogConfiguration] = Optional.Absent,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.WorkerSummary = {
    import WorkerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.WorkerSummary
      .builder()
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .optionallyWith(log.map(value => value.buildAwsValue()))(_.log)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.WorkerSummary.ReadOnly =
    zio.aws.deadline.model.WorkerSummary.wrap(buildAwsValue())
}
object WorkerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.WorkerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.WorkerSummary =
      zio.aws.deadline.model.WorkerSummary(
        workerId,
        farmId,
        fleetId,
        status,
        hostProperties.map(value => value.asEditable),
        log.map(value => value.asEditable),
        createdAt,
        createdBy,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def workerId: WorkerId
    def farmId: FarmId
    def fleetId: FleetId
    def status: zio.aws.deadline.model.WorkerStatus
    def hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesResponse.ReadOnly]
    def log: Optional[zio.aws.deadline.model.LogConfiguration.ReadOnly]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getStatus: ZIO[Any, Nothing, zio.aws.deadline.model.WorkerStatus] =
      ZIO.succeed(status)
    def getHostProperties: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.HostPropertiesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("hostProperties", hostProperties)
    def getLog
        : ZIO[Any, AwsError, zio.aws.deadline.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("log", log)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSummary
  ) extends zio.aws.deadline.model.WorkerSummary.ReadOnly {
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val status: zio.aws.deadline.model.WorkerStatus =
      zio.aws.deadline.model.WorkerStatus.wrap(impl.status())
    override val hostProperties
        : Optional[zio.aws.deadline.model.HostPropertiesResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostProperties())
        .map(value => zio.aws.deadline.model.HostPropertiesResponse.wrap(value))
    override val log
        : Optional[zio.aws.deadline.model.LogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.log())
        .map(value => zio.aws.deadline.model.LogConfiguration.wrap(value))
    override val createdAt: CreatedAt =
      zio.aws.deadline.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.deadline.model.primitives.CreatedBy(impl.createdBy())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.deadline.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.deadline.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.WorkerSummary
  ): zio.aws.deadline.model.WorkerSummary.ReadOnly = new Wrapper(impl)
}
