package zio.aws.deadline
import zio.aws.deadline.model.primitives.{
  SubnetId,
  OutputRelativeDirectoriesListMemberString,
  QueueId,
  FleetId,
  SecurityGroupId,
  IpV6Address,
  StepId,
  InstanceType,
  FileSystemLocationName,
  Integer,
  AttributeCapabilityValue,
  StorageProfileId,
  SessionId,
  IpV4Address,
  SessionActionId
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.deadline.model.primitives.IdentityCenterApplicationArn.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessKeyId extends zio.prelude.Subtype[String]
    type AccessKeyId = zio.aws.deadline.model.primitives.AccessKeyId.Type
    object AggregationId extends zio.prelude.Subtype[String]
    type AggregationId = zio.aws.deadline.model.primitives.AggregationId.Type
    object AmountCapabilityName extends zio.prelude.Subtype[String]
    type AmountCapabilityName =
      zio.aws.deadline.model.primitives.AmountCapabilityName.Type
    object AttributeCapabilityName extends zio.prelude.Subtype[String]
    type AttributeCapabilityName =
      zio.aws.deadline.model.primitives.AttributeCapabilityName.Type
    object AttributeCapabilityValue extends zio.prelude.Subtype[String]
    type AttributeCapabilityValue =
      zio.aws.deadline.model.primitives.AttributeCapabilityValue.Type
    object BoundedString extends zio.prelude.Subtype[String]
    type BoundedString = zio.aws.deadline.model.primitives.BoundedString.Type
    object BudgetId extends zio.prelude.Subtype[String]
    type BudgetId = zio.aws.deadline.model.primitives.BudgetId.Type
    object ClientToken extends zio.prelude.Subtype[String]
    type ClientToken = zio.aws.deadline.model.primitives.ClientToken.Type
    object CombinationExpression extends zio.prelude.Subtype[String]
    type CombinationExpression =
      zio.aws.deadline.model.primitives.CombinationExpression.Type
    object ConsumedUsageLimit extends zio.prelude.Subtype[Float]
    type ConsumedUsageLimit =
      zio.aws.deadline.model.primitives.ConsumedUsageLimit.Type
    object CreatedAt extends zio.prelude.Subtype[Instant]
    type CreatedAt = zio.aws.deadline.model.primitives.CreatedAt.Type
    object CreatedBy extends zio.prelude.Subtype[String]
    type CreatedBy = zio.aws.deadline.model.primitives.CreatedBy.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.deadline.model.primitives.Description.Type
    object DnsName extends zio.prelude.Subtype[String]
    type DnsName = zio.aws.deadline.model.primitives.DnsName.Type
    object EbsIops extends zio.prelude.Subtype[Int]
    type EbsIops = zio.aws.deadline.model.primitives.EbsIops.Type
    object EbsThroughputMiB extends zio.prelude.Subtype[Int]
    type EbsThroughputMiB =
      zio.aws.deadline.model.primitives.EbsThroughputMiB.Type
    object EndedAt extends zio.prelude.Subtype[Instant]
    type EndedAt = zio.aws.deadline.model.primitives.EndedAt.Type
    object EndsAt extends zio.prelude.Subtype[Instant]
    type EndsAt = zio.aws.deadline.model.primitives.EndsAt.Type
    object EnvironmentId extends zio.prelude.Subtype[String]
    type EnvironmentId = zio.aws.deadline.model.primitives.EnvironmentId.Type
    object EnvironmentName extends zio.prelude.Subtype[String]
    type EnvironmentName =
      zio.aws.deadline.model.primitives.EnvironmentName.Type
    object EnvironmentTemplate extends zio.prelude.Subtype[String]
    type EnvironmentTemplate =
      zio.aws.deadline.model.primitives.EnvironmentTemplate.Type
    object FarmId extends zio.prelude.Subtype[String]
    type FarmId = zio.aws.deadline.model.primitives.FarmId.Type
    object FileSystemLocationName extends zio.prelude.Subtype[String]
    type FileSystemLocationName =
      zio.aws.deadline.model.primitives.FileSystemLocationName.Type
    object FleetId extends zio.prelude.Subtype[String]
    type FleetId = zio.aws.deadline.model.primitives.FleetId.Type
    object FloatString extends zio.prelude.Subtype[String]
    type FloatString = zio.aws.deadline.model.primitives.FloatString.Type
    object HostName extends zio.prelude.Subtype[String]
    type HostName = zio.aws.deadline.model.primitives.HostName.Type
    object IamRoleArn extends zio.prelude.Subtype[String]
    type IamRoleArn = zio.aws.deadline.model.primitives.IamRoleArn.Type
    object IdentityCenterApplicationArn extends zio.prelude.Subtype[String]
    type IdentityCenterApplicationArn =
      zio.aws.deadline.model.primitives.IdentityCenterApplicationArn.Type
    object IdentityCenterInstanceArn extends zio.prelude.Subtype[String]
    type IdentityCenterInstanceArn =
      zio.aws.deadline.model.primitives.IdentityCenterInstanceArn.Type
    object IdentityCenterPrincipalId extends zio.prelude.Subtype[String]
    type IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives.IdentityCenterPrincipalId.Type
    object IdentityStoreId extends zio.prelude.Subtype[String]
    type IdentityStoreId =
      zio.aws.deadline.model.primitives.IdentityStoreId.Type
    object InstanceType extends zio.prelude.Subtype[String]
    type InstanceType = zio.aws.deadline.model.primitives.InstanceType.Type
    object IntString extends zio.prelude.Subtype[String]
    type IntString = zio.aws.deadline.model.primitives.IntString.Type
    type Integer = Int
    object IpV4Address extends zio.prelude.Subtype[String]
    type IpV4Address = zio.aws.deadline.model.primitives.IpV4Address.Type
    object IpV6Address extends zio.prelude.Subtype[String]
    type IpV6Address = zio.aws.deadline.model.primitives.IpV6Address.Type
    object JobDescription extends zio.prelude.Subtype[String]
    type JobDescription = zio.aws.deadline.model.primitives.JobDescription.Type
    object JobId extends zio.prelude.Subtype[String]
    type JobId = zio.aws.deadline.model.primitives.JobId.Type
    object JobName extends zio.prelude.Subtype[String]
    type JobName = zio.aws.deadline.model.primitives.JobName.Type
    object JobPriority extends zio.prelude.Subtype[Int]
    type JobPriority = zio.aws.deadline.model.primitives.JobPriority.Type
    object JobTemplate extends zio.prelude.Subtype[String]
    type JobTemplate = zio.aws.deadline.model.primitives.JobTemplate.Type
    object KmsKeyArn extends zio.prelude.Subtype[String]
    type KmsKeyArn = zio.aws.deadline.model.primitives.KmsKeyArn.Type
    object LicenseEndpointId extends zio.prelude.Subtype[String]
    type LicenseEndpointId =
      zio.aws.deadline.model.primitives.LicenseEndpointId.Type
    object LicenseProduct extends zio.prelude.Subtype[String]
    type LicenseProduct = zio.aws.deadline.model.primitives.LicenseProduct.Type
    object ListStepConsumersRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListStepConsumersRequestMaxResultsInteger =
      zio.aws.deadline.model.primitives.ListStepConsumersRequestMaxResultsInteger.Type
    object ListStepDependenciesRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListStepDependenciesRequestMaxResultsInteger =
      zio.aws.deadline.model.primitives.ListStepDependenciesRequestMaxResultsInteger.Type
    object LogDriver extends zio.prelude.Subtype[String]
    type LogDriver = zio.aws.deadline.model.primitives.LogDriver.Type
    object LogError extends zio.prelude.Subtype[String]
    type LogError = zio.aws.deadline.model.primitives.LogError.Type
    object ManifestPropertiesInputManifestHashString
        extends zio.prelude.Subtype[String]
    type ManifestPropertiesInputManifestHashString =
      zio.aws.deadline.model.primitives.ManifestPropertiesInputManifestHashString.Type
    object ManifestPropertiesInputManifestPathString
        extends zio.prelude.Subtype[String]
    type ManifestPropertiesInputManifestPathString =
      zio.aws.deadline.model.primitives.ManifestPropertiesInputManifestPathString.Type
    object ManifestPropertiesRootPathString extends zio.prelude.Subtype[String]
    type ManifestPropertiesRootPathString =
      zio.aws.deadline.model.primitives.ManifestPropertiesRootPathString.Type
    object MaxFailedTasksCount extends zio.prelude.Subtype[Int]
    type MaxFailedTasksCount =
      zio.aws.deadline.model.primitives.MaxFailedTasksCount.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.deadline.model.primitives.MaxResults.Type
    object MaxRetriesPerTask extends zio.prelude.Subtype[Int]
    type MaxRetriesPerTask =
      zio.aws.deadline.model.primitives.MaxRetriesPerTask.Type
    object MemoryAmountMiB extends zio.prelude.Subtype[Int]
    type MemoryAmountMiB =
      zio.aws.deadline.model.primitives.MemoryAmountMiB.Type
    object MeteredProductId extends zio.prelude.Subtype[String]
    type MeteredProductId =
      zio.aws.deadline.model.primitives.MeteredProductId.Type
    object MinOneMaxTenThousand extends zio.prelude.Subtype[Int]
    type MinOneMaxTenThousand =
      zio.aws.deadline.model.primitives.MinOneMaxTenThousand.Type
    object MinZeroMaxInteger extends zio.prelude.Subtype[Int]
    type MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger.Type
    object MonitorId extends zio.prelude.Subtype[String]
    type MonitorId = zio.aws.deadline.model.primitives.MonitorId.Type
    object NextItemOffset extends zio.prelude.Subtype[Int]
    type NextItemOffset = zio.aws.deadline.model.primitives.NextItemOffset.Type
    object OutputRelativeDirectoriesListMemberString
        extends zio.prelude.Subtype[String]
    type OutputRelativeDirectoriesListMemberString =
      zio.aws.deadline.model.primitives.OutputRelativeDirectoriesListMemberString.Type
    object ParameterString extends zio.prelude.Subtype[String]
    type ParameterString =
      zio.aws.deadline.model.primitives.ParameterString.Type
    object ParameterValue extends zio.prelude.Subtype[String]
    type ParameterValue = zio.aws.deadline.model.primitives.ParameterValue.Type
    object PathString extends zio.prelude.Subtype[String]
    type PathString = zio.aws.deadline.model.primitives.PathString.Type
    object PortNumber extends zio.prelude.Subtype[Int]
    type PortNumber = zio.aws.deadline.model.primitives.PortNumber.Type
    object PosixUserGroupString extends zio.prelude.Subtype[String]
    type PosixUserGroupString =
      zio.aws.deadline.model.primitives.PosixUserGroupString.Type
    object PosixUserUserString extends zio.prelude.Subtype[String]
    type PosixUserUserString =
      zio.aws.deadline.model.primitives.PosixUserUserString.Type
    object Priority extends zio.prelude.Subtype[Int]
    type Priority = zio.aws.deadline.model.primitives.Priority.Type
    object ProcessExitCode extends zio.prelude.Subtype[Int]
    type ProcessExitCode =
      zio.aws.deadline.model.primitives.ProcessExitCode.Type
    object QueueEnvironmentId extends zio.prelude.Subtype[String]
    type QueueEnvironmentId =
      zio.aws.deadline.model.primitives.QueueEnvironmentId.Type
    object QueueId extends zio.prelude.Subtype[String]
    type QueueId = zio.aws.deadline.model.primitives.QueueId.Type
    object ResourceName extends zio.prelude.Subtype[String]
    type ResourceName = zio.aws.deadline.model.primitives.ResourceName.Type
    object S3BucketName extends zio.prelude.Subtype[String]
    type S3BucketName = zio.aws.deadline.model.primitives.S3BucketName.Type
    object S3Key extends zio.prelude.Subtype[String]
    type S3Key = zio.aws.deadline.model.primitives.S3Key.Type
    object S3Prefix extends zio.prelude.Subtype[String]
    type S3Prefix = zio.aws.deadline.model.primitives.S3Prefix.Type
    object SearchJobsRequestItemOffsetInteger extends zio.prelude.Subtype[Int]
    type SearchJobsRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives.SearchJobsRequestItemOffsetInteger.Type
    object SearchJobsRequestPageSizeInteger extends zio.prelude.Subtype[Int]
    type SearchJobsRequestPageSizeInteger =
      zio.aws.deadline.model.primitives.SearchJobsRequestPageSizeInteger.Type
    object SearchStepsRequestItemOffsetInteger extends zio.prelude.Subtype[Int]
    type SearchStepsRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives.SearchStepsRequestItemOffsetInteger.Type
    object SearchStepsRequestPageSizeInteger extends zio.prelude.Subtype[Int]
    type SearchStepsRequestPageSizeInteger =
      zio.aws.deadline.model.primitives.SearchStepsRequestPageSizeInteger.Type
    object SearchTasksRequestItemOffsetInteger extends zio.prelude.Subtype[Int]
    type SearchTasksRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives.SearchTasksRequestItemOffsetInteger.Type
    object SearchTasksRequestPageSizeInteger extends zio.prelude.Subtype[Int]
    type SearchTasksRequestPageSizeInteger =
      zio.aws.deadline.model.primitives.SearchTasksRequestPageSizeInteger.Type
    object SearchTerm extends zio.prelude.Subtype[String]
    type SearchTerm = zio.aws.deadline.model.primitives.SearchTerm.Type
    object SearchWorkersRequestItemOffsetInteger
        extends zio.prelude.Subtype[Int]
    type SearchWorkersRequestItemOffsetInteger =
      zio.aws.deadline.model.primitives.SearchWorkersRequestItemOffsetInteger.Type
    object SearchWorkersRequestPageSizeInteger extends zio.prelude.Subtype[Int]
    type SearchWorkersRequestPageSizeInteger =
      zio.aws.deadline.model.primitives.SearchWorkersRequestPageSizeInteger.Type
    object SecretAccessKey extends zio.prelude.Subtype[String]
    type SecretAccessKey =
      zio.aws.deadline.model.primitives.SecretAccessKey.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId =
      zio.aws.deadline.model.primitives.SecurityGroupId.Type
    object SessionActionId extends zio.prelude.Subtype[String]
    type SessionActionId =
      zio.aws.deadline.model.primitives.SessionActionId.Type
    object SessionActionProgressMessage extends zio.prelude.Subtype[String]
    type SessionActionProgressMessage =
      zio.aws.deadline.model.primitives.SessionActionProgressMessage.Type
    object SessionActionProgressPercent extends zio.prelude.Subtype[Float]
    type SessionActionProgressPercent =
      zio.aws.deadline.model.primitives.SessionActionProgressPercent.Type
    object SessionId extends zio.prelude.Subtype[String]
    type SessionId = zio.aws.deadline.model.primitives.SessionId.Type
    object SessionToken extends zio.prelude.Subtype[String]
    type SessionToken = zio.aws.deadline.model.primitives.SessionToken.Type
    object StartedAt extends zio.prelude.Subtype[Instant]
    type StartedAt = zio.aws.deadline.model.primitives.StartedAt.Type
    object StartsAt extends zio.prelude.Subtype[Instant]
    type StartsAt = zio.aws.deadline.model.primitives.StartsAt.Type
    object StatusMessage extends zio.prelude.Subtype[String]
    type StatusMessage = zio.aws.deadline.model.primitives.StatusMessage.Type
    object StepDescription extends zio.prelude.Subtype[String]
    type StepDescription =
      zio.aws.deadline.model.primitives.StepDescription.Type
    object StepId extends zio.prelude.Subtype[String]
    type StepId = zio.aws.deadline.model.primitives.StepId.Type
    object StepName extends zio.prelude.Subtype[String]
    type StepName = zio.aws.deadline.model.primitives.StepName.Type
    object StepParameterName extends zio.prelude.Subtype[String]
    type StepParameterName =
      zio.aws.deadline.model.primitives.StepParameterName.Type
    object StorageProfileId extends zio.prelude.Subtype[String]
    type StorageProfileId =
      zio.aws.deadline.model.primitives.StorageProfileId.Type
    object StringFilter extends zio.prelude.Subtype[String]
    type StringFilter = zio.aws.deadline.model.primitives.StringFilter.Type
    object Subdomain extends zio.prelude.Subtype[String]
    type Subdomain = zio.aws.deadline.model.primitives.Subdomain.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.deadline.model.primitives.SubnetId.Type
    object SyntheticTimestamp_date_time extends zio.prelude.Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.deadline.model.primitives.SyntheticTimestamp_date_time.Type
    object TaskId extends zio.prelude.Subtype[String]
    type TaskId = zio.aws.deadline.model.primitives.TaskId.Type
    object TaskRetryCount extends zio.prelude.Subtype[Int]
    type TaskRetryCount = zio.aws.deadline.model.primitives.TaskRetryCount.Type
    object ThresholdPercentage extends zio.prelude.Subtype[Float]
    type ThresholdPercentage =
      zio.aws.deadline.model.primitives.ThresholdPercentage.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.deadline.model.primitives.Timestamp.Type
    object Timezone extends zio.prelude.Subtype[String]
    type Timezone = zio.aws.deadline.model.primitives.Timezone.Type
    object TotalResults extends zio.prelude.Subtype[Int]
    type TotalResults = zio.aws.deadline.model.primitives.TotalResults.Type
    object UpdateWorkerScheduleInterval extends zio.prelude.Subtype[Int]
    type UpdateWorkerScheduleInterval =
      zio.aws.deadline.model.primitives.UpdateWorkerScheduleInterval.Type
    object UpdatedAt extends zio.prelude.Subtype[Instant]
    type UpdatedAt = zio.aws.deadline.model.primitives.UpdatedAt.Type
    object UpdatedBy extends zio.prelude.Subtype[String]
    type UpdatedBy = zio.aws.deadline.model.primitives.UpdatedBy.Type
    object Url extends zio.prelude.Subtype[String]
    type Url = zio.aws.deadline.model.primitives.Url.Type
    object UserId extends zio.prelude.Subtype[String]
    type UserId = zio.aws.deadline.model.primitives.UserId.Type
    object VpcId extends zio.prelude.Subtype[String]
    type VpcId = zio.aws.deadline.model.primitives.VpcId.Type
    object WindowsUserPasswordArnString extends zio.prelude.Subtype[String]
    type WindowsUserPasswordArnString =
      zio.aws.deadline.model.primitives.WindowsUserPasswordArnString.Type
    object WindowsUserUserString extends zio.prelude.Subtype[String]
    type WindowsUserUserString =
      zio.aws.deadline.model.primitives.WindowsUserUserString.Type
    object WorkerId extends zio.prelude.Subtype[String]
    type WorkerId = zio.aws.deadline.model.primitives.WorkerId.Type
  }
  type AcceleratorTypes = List[zio.aws.deadline.model.AcceleratorType]
  type AllowedStorageProfileIds = List[StorageProfileId]
  type AssignedSessionActions =
    List[zio.aws.deadline.model.AssignedSessionAction]
  type AssignedSessions = Map[SessionId, zio.aws.deadline.model.AssignedSession]
  type AttributeCapabilityValuesList = List[AttributeCapabilityValue]
  type BatchGetJobEntityErrors = List[zio.aws.deadline.model.GetJobEntityError]
  type BatchGetJobEntityList = List[zio.aws.deadline.model.JobEntity]
  type BudgetActionsToAdd = List[zio.aws.deadline.model.BudgetActionToAdd]
  type BudgetActionsToRemove = List[zio.aws.deadline.model.BudgetActionToRemove]
  type BudgetSummaries = List[zio.aws.deadline.model.BudgetSummary]
  type CancelSessionActions = Map[SessionId, Iterable[SessionActionId]]
  type CreateLicenseEndpointRequestSecurityGroupIdsList = List[SecurityGroupId]
  type CreateLicenseEndpointRequestSubnetIdsList = List[SubnetId]
  type CustomFleetAmountCapabilities =
    List[zio.aws.deadline.model.FleetAmountCapability]
  type CustomFleetAttributeCapabilities =
    List[zio.aws.deadline.model.FleetAttributeCapability]
  type DependenciesList = List[StepId]
  type Document = software.amazon.awssdk.core.document.Document
  type FarmMembers = List[zio.aws.deadline.model.FarmMember]
  type FarmSummaries = List[zio.aws.deadline.model.FarmSummary]
  type FileSystemLocationsList = List[zio.aws.deadline.model.FileSystemLocation]
  type FleetAmountCapabilities =
    List[zio.aws.deadline.model.FleetAmountCapability]
  type FleetAttributeCapabilities =
    List[zio.aws.deadline.model.FleetAttributeCapability]
  type FleetMembers = List[zio.aws.deadline.model.FleetMember]
  type FleetSummaries = List[zio.aws.deadline.model.FleetSummary]
  type GetLicenseEndpointResponseSecurityGroupIdsList = List[SecurityGroupId]
  type GetLicenseEndpointResponseSubnetIdsList = List[SubnetId]
  type InstanceTypes = List[InstanceType]
  type IpV4Addresses = List[IpV4Address]
  type IpV6Addresses = List[IpV6Address]
  type JobEntityIdentifiers =
    List[zio.aws.deadline.model.JobEntityIdentifiersUnion]
  type JobMembers = List[zio.aws.deadline.model.JobMember]
  type JobParameterDefinition = software.amazon.awssdk.core.document.Document
  type JobParameterDefinitions =
    List[zio.aws.deadline.model.JobParameterDefinition]
  type JobParameters = Map[String, zio.aws.deadline.model.JobParameter]
  type JobSearchSummaries = List[zio.aws.deadline.model.JobSearchSummary]
  type JobSummaries = List[zio.aws.deadline.model.JobSummary]
  type LicenseEndpointSummaries =
    List[zio.aws.deadline.model.LicenseEndpointSummary]
  type ListAttributeCapabilityValue = List[AttributeCapabilityValue]
  type ListSessionsForWorkerSummaries =
    List[zio.aws.deadline.model.WorkerSessionSummary]
  type LogOptions = Map[String, String]
  type LogParameters = Map[String, String]
  type ManifestPropertiesList = List[zio.aws.deadline.model.ManifestProperties]
  type MeteredProductSummaryList =
    List[zio.aws.deadline.model.MeteredProductSummary]
  type MonitorSummaries = List[zio.aws.deadline.model.MonitorSummary]
  type OutputRelativeDirectoriesList =
    List[OutputRelativeDirectoriesListMemberString]
  type PathMappingRules = List[zio.aws.deadline.model.PathMappingRule]
  type QueueEnvironmentSummaries =
    List[zio.aws.deadline.model.QueueEnvironmentSummary]
  type QueueFleetAssociationSummaries =
    List[zio.aws.deadline.model.QueueFleetAssociationSummary]
  type QueueMemberList = List[zio.aws.deadline.model.QueueMember]
  type QueueSummaries = List[zio.aws.deadline.model.QueueSummary]
  type RequiredFileSystemLocationNames = List[FileSystemLocationName]
  type ResponseBudgetActionList =
    List[zio.aws.deadline.model.ResponseBudgetAction]
  type SearchFilterExpressions =
    List[zio.aws.deadline.model.SearchFilterExpression]
  type SearchJobsRequestQueueIdsList = List[QueueId]
  type SearchSortExpressions = List[zio.aws.deadline.model.SearchSortExpression]
  type SearchStepsRequestQueueIdsList = List[QueueId]
  type SearchTasksRequestQueueIdsList = List[QueueId]
  type SearchWorkersRequestFleetIdsList = List[FleetId]
  type SessionActionIdList = List[SessionActionId]
  type SessionActionSummaries =
    List[zio.aws.deadline.model.SessionActionSummary]
  type SessionSummaries = List[zio.aws.deadline.model.SessionSummary]
  type SessionsStatisticsResourcesFleetIdsList = List[FleetId]
  type SessionsStatisticsResourcesQueueIdsList = List[QueueId]
  type StatisticsList = List[zio.aws.deadline.model.Statistics]
  type StepAmountCapabilities =
    List[zio.aws.deadline.model.StepAmountCapability]
  type StepAttributeCapabilities =
    List[zio.aws.deadline.model.StepAttributeCapability]
  type StepConsumers = List[zio.aws.deadline.model.StepConsumer]
  type StepDependencies = List[zio.aws.deadline.model.StepDependency]
  type StepParameterList = List[zio.aws.deadline.model.StepParameter]
  type StepSearchSummaries = List[zio.aws.deadline.model.StepSearchSummary]
  type StepSummaries = List[zio.aws.deadline.model.StepSummary]
  type StorageProfileSummaries =
    List[zio.aws.deadline.model.StorageProfileSummary]
  type StringList = List[String]
  type Tags = Map[String, String]
  type TaskParameters = Map[String, zio.aws.deadline.model.TaskParameterValue]
  type TaskRunStatusCounts = Map[zio.aws.deadline.model.TaskRunStatus, Integer]
  type TaskSearchSummaries = List[zio.aws.deadline.model.TaskSearchSummary]
  type TaskSummaries = List[zio.aws.deadline.model.TaskSummary]
  type UpdatedSessionActions =
    Map[SessionActionId, zio.aws.deadline.model.UpdatedSessionActionInfo]
  type UsageGroupBy = List[zio.aws.deadline.model.UsageGroupByField]
  type UsageStatistics = List[zio.aws.deadline.model.UsageStatistic]
  type WorkerAmountCapabilityList =
    List[zio.aws.deadline.model.WorkerAmountCapability]
  type WorkerAttributeCapabilityList =
    List[zio.aws.deadline.model.WorkerAttributeCapability]
  type WorkerSearchSummaries = List[zio.aws.deadline.model.WorkerSearchSummary]
  type WorkerSummaries = List[zio.aws.deadline.model.WorkerSummary]
}
