package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{Timestamp, GraphArn, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Administrator(
    accountId: Option[AccountId] = None,
    graphArn: Option[GraphArn] = None,
    delegationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.Administrator = {
    import Administrator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.Administrator
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        delegationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.delegationTime)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.Administrator.ReadOnly =
    zio.aws.detective.model.Administrator.wrap(buildAwsValue())
}
object Administrator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.Administrator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.Administrator =
      zio.aws.detective.model.Administrator(
        accountId.map(value => value),
        graphArn.map(value => value),
        delegationTime.map(value => value)
      )
    def accountId: Option[AccountId]
    def graphArn: Option[GraphArn]
    def delegationTime: Option[Timestamp]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getDelegationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("delegationTime", delegationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.Administrator
  ) extends zio.aws.detective.model.Administrator.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val graphArn: Option[GraphArn] = scala
      .Option(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val delegationTime: Option[Timestamp] = scala
      .Option(impl.delegationTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.Administrator
  ): zio.aws.detective.model.Administrator.ReadOnly = new Wrapper(impl)
}
