package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{TagValue, TagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGraphRequest(
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.CreateGraphRequest = {
    import CreateGraphRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.CreateGraphRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.CreateGraphRequest.ReadOnly =
    zio.aws.detective.model.CreateGraphRequest.wrap(buildAwsValue())
}
object CreateGraphRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.CreateGraphRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.CreateGraphRequest =
      zio.aws.detective.model.CreateGraphRequest(tags.map(value => value))
    def tags: Option[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.CreateGraphRequest
  ) extends zio.aws.detective.model.CreateGraphRequest.ReadOnly {
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.primitives
              .TagKey(key) -> zio.aws.detective.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.CreateGraphRequest
  ): zio.aws.detective.model.CreateGraphRequest.ReadOnly = new Wrapper(impl)
}
