package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGraphResponse(graphArn: Option[GraphArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.CreateGraphResponse = {
    import CreateGraphResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.CreateGraphResponse
      .builder()
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.CreateGraphResponse.ReadOnly =
    zio.aws.detective.model.CreateGraphResponse.wrap(buildAwsValue())
}
object CreateGraphResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.CreateGraphResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.CreateGraphResponse =
      zio.aws.detective.model.CreateGraphResponse(graphArn.map(value => value))
    def graphArn: Option[GraphArn]
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.CreateGraphResponse
  ) extends zio.aws.detective.model.CreateGraphResponse.ReadOnly {
    override val graphArn: Option[GraphArn] = scala
      .Option(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.CreateGraphResponse
  ): zio.aws.detective.model.CreateGraphResponse.ReadOnly = new Wrapper(impl)
}
