package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateMembersResponse(
    members: Option[Iterable[zio.aws.detective.model.MemberDetail]] = None,
    unprocessedAccounts: Option[
      Iterable[zio.aws.detective.model.UnprocessedAccount]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.CreateMembersResponse = {
    import CreateMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.CreateMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.CreateMembersResponse.ReadOnly =
    zio.aws.detective.model.CreateMembersResponse.wrap(buildAwsValue())
}
object CreateMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.CreateMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.CreateMembersResponse =
      zio.aws.detective.model.CreateMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def members: Option[List[zio.aws.detective.model.MemberDetail.ReadOnly]]
    def unprocessedAccounts
        : Option[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]]
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MemberDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.detective.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.CreateMembersResponse
  ) extends zio.aws.detective.model.CreateMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.detective.model.MemberDetail.ReadOnly]] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.MemberDetail.wrap(item)
        }.toList
      )
    override val unprocessedAccounts
        : Option[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]] =
      scala
        .Option(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.CreateMembersResponse
  ): zio.aws.detective.model.CreateMembersResponse.ReadOnly = new Wrapper(impl)
}
