package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{AccountId, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMembersRequest(
    graphArn: GraphArn,
    accountIds: Iterable[AccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DeleteMembersRequest = {
    import DeleteMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DeleteMembersRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.DeleteMembersRequest.ReadOnly =
    zio.aws.detective.model.DeleteMembersRequest.wrap(buildAwsValue())
}
object DeleteMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DeleteMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.DeleteMembersRequest =
      zio.aws.detective.model.DeleteMembersRequest(graphArn, accountIds)
    def graphArn: GraphArn
    def accountIds: List[AccountId]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DeleteMembersRequest
  ) extends zio.aws.detective.model.DeleteMembersRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.detective.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DeleteMembersRequest
  ): zio.aws.detective.model.DeleteMembersRequest.ReadOnly = new Wrapper(impl)
}
